/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.analytic.AnalyticItemWrapper;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.clustering.CentroidManager;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.core.index.FloatCompareUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripWeakCentroidsRunner<T>
implements MapReduceJobRunner {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StripWeakCentroidsRunner.class);
    private int minimum = 1;
    private int maximum = 1000;
    private int currentCentroidCount = 0;
    private BreakStrategy<T> breakStrategy = new TailMaxBreakStrategy();

    public void setBreakStrategy(BreakStrategy<T> breakStrategy) {
        this.breakStrategy = breakStrategy;
    }

    public void setRange(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public int getCurrentCentroidCount() {
        return this.currentCentroidCount;
    }

    protected CentroidManager<T> constructCentroidManager(Configuration config, PropertyManagement runTimeProperties) throws IOException {
        return new CentroidManagerGeoWave(runTimeProperties);
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        this.currentCentroidCount = 0;
        final CentroidManager<T> centroidManager = this.constructCentroidManager(config, runTimeProperties);
        return centroidManager.processForAllGroups(new CentroidManager.CentroidProcessingFn<T>(){

            public int processGroup(String groupID, List<AnalyticItemWrapper<T>> centroids) {
                if (centroids.size() <= StripWeakCentroidsRunner.this.minimum) {
                    StripWeakCentroidsRunner.this.currentCentroidCount = centroids.size();
                    return 0;
                }
                Collections.sort(centroids, new Comparator<AnalyticItemWrapper<T>>(){

                    @Override
                    public int compare(AnalyticItemWrapper<T> arg0, AnalyticItemWrapper<T> arg1) {
                        return arg1.getAssociationCount() - arg0.getAssociationCount() < 0L ? -1 : 1;
                    }
                });
                int position = StripWeakCentroidsRunner.this.breakStrategy.getBreakPoint(centroids);
                position = Math.min(Math.max(StripWeakCentroidsRunner.this.minimum, position), StripWeakCentroidsRunner.this.maximum);
                String[] toDelete = new String[centroids.size() - position];
                LOGGER.info("Deleting {} out of {}", (Object)toDelete.length, (Object)centroids.size());
                int count = 0;
                for (AnalyticItemWrapper centroid : centroids) {
                    if (count++ < position) continue;
                    toDelete[count - position - 1] = centroid.getID();
                }
                try {
                    centroidManager.delete(toDelete);
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to delete the centriod mamager", (Throwable)e);
                    return -1;
                }
                StripWeakCentroidsRunner.this.currentCentroidCount = StripWeakCentroidsRunner.this.currentCentroidCount + position;
                return 0;
            }
        });
    }

    public static interface BreakStrategy<T> {
        public int getBreakPoint(List<AnalyticItemWrapper<T>> var1);
    }

    public static class TailStableChangeBreakStrategy<T>
    extends StableChangeBreakStrategy<T>
    implements BreakStrategy<T> {
        @Override
        protected double getInitialMaximum(StandardDeviation stats, double total) {
            return total / (double)stats.getN() + stats.getResult();
        }
    }

    public static class TailMaxBreakStrategy<T>
    extends MaxChangeBreakStrategy<T>
    implements BreakStrategy<T> {
        @Override
        protected double getInitialMaximum(StandardDeviation stats, double total) {
            return total / (double)stats.getN() + stats.getResult();
        }
    }

    public static class StableChangeBreakStrategy<T>
    implements BreakStrategy<T> {
        @Override
        public int getBreakPoint(List<AnalyticItemWrapper<T>> centroids) {
            ArrayList<ChangeFromLast> changes = new ArrayList<ChangeFromLast>(centroids.size());
            StandardDeviation st = new StandardDeviation();
            double prior = Double.NaN;
            double total = 0.0;
            int count = 0;
            for (AnalyticItemWrapper<T> centroid : centroids) {
                double chgValue = !Double.isNaN(prior) ? Math.abs(prior - (double)centroid.getAssociationCount()) : 0.0;
                changes.add(new ChangeFromLast(count, chgValue));
                prior = centroid.getAssociationCount();
                ++count;
            }
            Collections.sort(changes);
            int position = centroids.size();
            count = 0;
            ChangeFromLast priorChg = null;
            for (ChangeFromLast changeFromLast : changes) {
                if (priorChg != null) {
                    double chgOfChg = Math.abs(priorChg.chg - changeFromLast.chg);
                    total += chgOfChg;
                    st.increment(chgOfChg);
                }
                priorChg = changeFromLast;
                ++count;
            }
            double max = this.getInitialMaximum(st, total);
            position = ((ChangeFromLast)changes.get((int)0)).position;
            if (((ChangeFromLast)changes.get((int)0)).chg < max) {
                return centroids.size();
            }
            priorChg = null;
            for (ChangeFromLast changeFromLast : changes) {
                double chgOfChg;
                if (priorChg != null && (chgOfChg = Math.abs(priorChg.chg - changeFromLast.chg)) > max) {
                    position = Math.max(position, changeFromLast.position);
                    max = chgOfChg;
                }
                priorChg = changeFromLast;
            }
            return position;
        }

        protected double getInitialMaximum(StandardDeviation stats, double total) {
            return 0.0;
        }
    }

    private static class ChangeFromLast
    implements Comparable<ChangeFromLast> {
        int position;
        double chg;

        public ChangeFromLast(int position, double chg) {
            this.position = position;
            this.chg = chg;
        }

        public String toString() {
            return "ChangeFromLast [position=" + this.position + ", chg=" + this.chg + "]";
        }

        @Override
        public int compareTo(ChangeFromLast arg0) {
            return new Double(arg0.chg).compareTo(this.chg);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ChangeFromLast)) {
                return false;
            }
            return this.compareTo((ChangeFromLast)obj) == 0;
        }

        public int hashCode() {
            return Double.valueOf(this.chg).hashCode();
        }
    }

    public static class MaxChangeBreakStrategy<T>
    implements BreakStrategy<T> {
        @Override
        public int getBreakPoint(List<AnalyticItemWrapper<T>> centroids) {
            int position = centroids.size();
            int count = 0;
            StandardDeviation st = new StandardDeviation();
            double total = 0.0;
            double prior = Double.NaN;
            for (AnalyticItemWrapper<T> centroid : centroids) {
                if (!Double.isNaN(prior)) {
                    double chg = Math.abs(prior - (double)centroid.getAssociationCount());
                    st.increment(chg);
                    total += chg;
                }
                prior = centroid.getAssociationCount();
            }
            double max = this.getInitialMaximum(st, total);
            prior = Double.NaN;
            for (AnalyticItemWrapper<T> centroid : centroids) {
                double chg;
                if (centroid.getAssociationCount() <= 1L) {
                    if (position != 0) break;
                    position = count;
                    break;
                }
                if (!Double.isNaN(prior) && FloatCompareUtils.checkDoublesEqual((double)Math.max(max, chg = Math.abs(prior - (double)centroid.getAssociationCount())), (double)chg)) {
                    position = count;
                    max = chg;
                }
                prior = centroid.getAssociationCount();
                ++count;
            }
            return position;
        }

        protected double getInitialMaximum(StandardDeviation stats, double total) {
            return 0.0;
        }
    }
}

