/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.kmeans.runner;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.clustering.CentroidManagerGeoWave;
import org.locationtech.geowave.analytic.clustering.NestedGroupCentroidAssignment;
import org.locationtech.geowave.analytic.mapreduce.CountofDoubleWritable;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveOutputFormatConfiguration;
import org.locationtech.geowave.analytic.mapreduce.GroupIDText;
import org.locationtech.geowave.analytic.mapreduce.MapReduceJobRunner;
import org.locationtech.geowave.analytic.mapreduce.kmeans.UpdateCentroidCostMapReduce;
import org.locationtech.geowave.analytic.param.CentroidParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.mapreduce.output.GeoWaveOutputKey;
import org.opengis.feature.simple.SimpleFeature;

public class UpdateCentroidCostJobRunner
extends GeoWaveAnalyticJobRunner
implements MapReduceJobRunner {
    public UpdateCentroidCostJobRunner() {
        super.setOutputFormatConfiguration(new GeoWaveOutputFormatConfiguration());
    }

    @Override
    public Class<?> getScope() {
        return UpdateCentroidCostMapReduce.class;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        CentroidManagerGeoWave.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        NestedGroupCentroidAssignment.setParameters((Configuration)config, this.getScope(), (PropertyManagement)runTimeProperties);
        runTimeProperties.setConfig(new ParameterEnum[]{CentroidParameters.Centroid.WRAPPER_FACTORY_CLASS}, config, this.getScope());
        return super.run(config, runTimeProperties);
    }

    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(UpdateCentroidCostMapReduce.UpdateCentroidCostMap.class);
        job.setMapOutputKeyClass(GroupIDText.class);
        job.setMapOutputValueClass(CountofDoubleWritable.class);
        job.setCombinerClass(UpdateCentroidCostMapReduce.UpdateCentroidCostCombiner.class);
        job.setReducerClass(UpdateCentroidCostMapReduce.UpdateCentroidCostReducer.class);
        job.setReduceSpeculativeExecution(false);
        job.setOutputKeyClass(GeoWaveOutputKey.class);
        job.setOutputValueClass(SimpleFeature.class);
    }

    @Override
    protected String getJobName() {
        return "Update Centroid Cost";
    }
}

