/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.nn;

public class NNData<T>
implements Comparable<NNData<T>> {
    private T neighbor;
    private double distance;

    public NNData() {
    }

    public NNData(T neighbor, double distance) {
        this.neighbor = neighbor;
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    protected T getNeighbor() {
        return this.neighbor;
    }

    protected void setNeighbor(T neighbor) {
        this.neighbor = neighbor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.distance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.neighbor == null ? 0 : this.neighbor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NNData other = (NNData)obj;
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        return !(this.neighbor == null ? other.neighbor != null : !this.neighbor.equals(other.neighbor));
    }

    @Override
    public int compareTo(NNData<T> otherNNData) {
        int dist = Double.compare(this.distance, otherNNData.distance);
        return dist == 0 ? this.hashCode() - otherNNData.hashCode() : dist;
    }
}

