/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.nn;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geowave.analytic.AdapterWithObjectWritable;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.mapreduce.GeoWaveAnalyticJobRunner;
import org.locationtech.geowave.analytic.mapreduce.nn.NNMapReduce;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.PartitionParameters;
import org.locationtech.geowave.analytic.partitioner.OrthodromicDistancePartitioner;
import org.locationtech.geowave.analytic.partitioner.Partitioner;

public class NNJobRunner
extends GeoWaveAnalyticJobRunner {
    @Override
    public void configure(Job job) throws Exception {
        job.setMapperClass(NNMapReduce.NNMapper.class);
        job.setReducerClass(NNMapReduce.NNSimpleFeatureIDOutputReducer.class);
        job.setMapOutputKeyClass(NNMapReduce.PartitionDataWritable.class);
        job.setMapOutputValueClass(AdapterWithObjectWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setSpeculativeExecution(false);
    }

    @Override
    public Class<?> getScope() {
        return NNMapReduce.class;
    }

    @Override
    public int run(Configuration config, PropertyManagement runTimeProperties) throws Exception {
        Partitioner partitioner = (Partitioner)runTimeProperties.getClassInstance((ParameterEnum)PartitionParameters.Partition.PARTITIONER_CLASS, Partitioner.class, OrthodromicDistancePartitioner.class);
        Partitioner secondaryPartitioner = (Partitioner)runTimeProperties.getClassInstance((ParameterEnum)PartitionParameters.Partition.SECONDARY_PARTITIONER_CLASS, Partitioner.class, NNMapReduce.PassthruPartitioner.class);
        partitioner.setup(runTimeProperties, this.getScope(), config);
        if (secondaryPartitioner.getClass() != partitioner.getClass()) {
            secondaryPartitioner.setup(runTimeProperties, this.getScope(), config);
        }
        runTimeProperties.setConfig(new ParameterEnum[]{PartitionParameters.Partition.PARTITIONER_CLASS, PartitionParameters.Partition.SECONDARY_PARTITIONER_CLASS, PartitionParameters.Partition.MAX_DISTANCE, PartitionParameters.Partition.MAX_MEMBER_SELECTION, PartitionParameters.Partition.GEOMETRIC_DISTANCE_UNIT, PartitionParameters.Partition.DISTANCE_THRESHOLDS, CommonParameters.Common.DISTANCE_FUNCTION_CLASS}, config, this.getScope());
        return super.run(config, runTimeProperties);
    }

    @Override
    public Collection<ParameterEnum<?>> getParameters() {
        HashSet params = new HashSet();
        params.addAll(super.getParameters());
        params.addAll(Arrays.asList(PartitionParameters.Partition.PARTITIONER_CLASS, PartitionParameters.Partition.MAX_DISTANCE, PartitionParameters.Partition.SECONDARY_PARTITIONER_CLASS, PartitionParameters.Partition.MAX_MEMBER_SELECTION, PartitionParameters.Partition.GEOMETRIC_DISTANCE_UNIT, PartitionParameters.Partition.DISTANCE_THRESHOLDS, CommonParameters.Common.DISTANCE_FUNCTION_CLASS));
        return params;
    }

    @Override
    protected String getJobName() {
        return "Nearest Neighbors";
    }
}

