/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.nn;

import com.google.common.primitives.UnsignedBytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.locationtech.geowave.analytic.AdapterWithObjectWritable;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.ScopedJobConfiguration;
import org.locationtech.geowave.analytic.distance.DistanceFn;
import org.locationtech.geowave.analytic.distance.FeatureGeometryDistanceFn;
import org.locationtech.geowave.analytic.nn.DefaultNeighborList;
import org.locationtech.geowave.analytic.nn.DistanceProfile;
import org.locationtech.geowave.analytic.nn.DistanceProfileGenerateFn;
import org.locationtech.geowave.analytic.nn.NNProcessor;
import org.locationtech.geowave.analytic.nn.NeighborList;
import org.locationtech.geowave.analytic.nn.NeighborListFactory;
import org.locationtech.geowave.analytic.nn.TypeConverter;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.PartitionParameters;
import org.locationtech.geowave.analytic.partitioner.OrthodromicDistancePartitioner;
import org.locationtech.geowave.analytic.partitioner.Partitioner;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.mapreduce.HadoopWritableSerializationTool;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNMapReduce {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NNMapReduce.class);

    public static class PassthruPartitioner<T>
    implements Partitioner<T> {
        private static final long serialVersionUID = -1022316020113365561L;
        private static final List<Partitioner.PartitionData> FixedPartition = Collections.singletonList(new Partitioner.PartitionData(new ByteArray(new byte[0]), new ByteArray("1"), true));

        public void initialize(JobContext context, Class<?> scope) throws IOException {
        }

        public List<Partitioner.PartitionData> getCubeIdentifiers(T entry) {
            return FixedPartition;
        }

        public void partition(T entry, Partitioner.PartitionDataCallback callback) throws Exception {
            callback.partitionWith(FixedPartition.get(0));
        }

        public Collection<ParameterEnum<?>> getParameters() {
            return Collections.emptyList();
        }

        public void setup(PropertyManagement runTimeProperties, Class<?> scope, Configuration configuration) {
        }
    }

    public static class PartitionDataWritable
    implements Writable,
    WritableComparable<PartitionDataWritable> {
        protected Partitioner.PartitionData partitionData;

        public PartitionDataWritable() {
        }

        protected void setPartitionData(Partitioner.PartitionData partitionData) {
            this.partitionData = partitionData;
        }

        public Partitioner.PartitionData getPartitionData() {
            return this.partitionData;
        }

        public PartitionDataWritable(Partitioner.PartitionData partitionData) {
            this.partitionData = partitionData;
        }

        public void readFields(DataInput input) throws IOException {
            this.partitionData = new Partitioner.PartitionData();
            this.partitionData.readFields(input);
        }

        public void write(DataOutput output) throws IOException {
            this.partitionData.write(output);
        }

        public int compareTo(PartitionDataWritable o) {
            int val = UnsignedBytes.lexicographicalComparator().compare(this.partitionData.getCompositeKey().getBytes(), o.partitionData.getCompositeKey().getBytes());
            if (val == 0 && o.partitionData.getGroupId() != null && this.partitionData.getGroupId() != null) {
                return UnsignedBytes.lexicographicalComparator().compare(this.partitionData.getGroupId().getBytes(), o.partitionData.getGroupId().getBytes());
            }
            return val;
        }

        public String toString() {
            return this.partitionData.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.partitionData == null ? 0 : this.partitionData.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionDataWritable other = (PartitionDataWritable)obj;
            return !(this.partitionData == null ? other.partitionData != null : !this.partitionData.equals((Object)other.partitionData));
        }
    }

    public static class NNSimpleFeatureIDOutputReducer
    extends NNReducer<SimpleFeature, Text, Text, Boolean> {
        final Text primaryText = new Text();
        final Text neighborsText = new Text();
        final byte[] sepBytes = new byte[]{44};

        @Override
        protected void processNeighbors(Partitioner.PartitionData partitionData, ByteArray primaryId, SimpleFeature primary, NeighborList<SimpleFeature> neighbors, Reducer.Context context, Boolean summary) throws IOException, InterruptedException {
            if (neighbors == null || neighbors.size() == 0) {
                return;
            }
            this.primaryText.clear();
            this.neighborsText.clear();
            try {
                byte[] utfBytes = primary.getID().getBytes("UTF-8");
                this.primaryText.append(utfBytes, 0, utfBytes.length);
                for (Map.Entry neighbor : neighbors) {
                    if (this.neighborsText.getLength() > 0) {
                        this.neighborsText.append(this.sepBytes, 0, this.sepBytes.length);
                    }
                    utfBytes = ((SimpleFeature)neighbor.getValue()).getID().getBytes("UTF-8");
                    this.neighborsText.append(utfBytes, 0, utfBytes.length);
                }
                context.write((Object)this.primaryText, (Object)this.neighborsText);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 Encoding invalid for Simople feature ID", e);
            }
        }

        @Override
        protected Boolean createSummary() {
            return Boolean.TRUE;
        }

        @Override
        protected void processSummary(Partitioner.PartitionData partitionData, Boolean summary, Reducer.Context context) {
        }
    }

    public static abstract class NNReducer<VALUEIN, KEYOUT, VALUEOUT, PARTITION_SUMMARY>
    extends Reducer<PartitionDataWritable, AdapterWithObjectWritable, KEYOUT, VALUEOUT> {
        protected HadoopWritableSerializationTool serializationTool;
        protected DistanceFn<VALUEIN> distanceFn;
        protected double maxDistance = 1.0;
        protected int maxNeighbors = Integer.MAX_VALUE;
        protected Partitioner<Object> partitioner;
        protected TypeConverter<VALUEIN> typeConverter = new TypeConverter<VALUEIN>(){

            public VALUEIN convert(ByteArray id, Object o) {
                return o;
            }
        };
        protected DistanceProfileGenerateFn<?, VALUEIN> distanceProfileFn = new LocalDistanceProfileGenerateFn();

        protected void reduce(final PartitionDataWritable key, Iterable<AdapterWithObjectWritable> values, final Reducer.Context context) throws IOException, InterruptedException {
            final NNProcessor processor = new NNProcessor(this.partitioner, this.typeConverter, this.distanceProfileFn, this.maxDistance, key.partitionData);
            processor.setUpperBoundPerPartition(this.maxNeighbors);
            final PARTITION_SUMMARY summary = this.createSummary();
            for (AdapterWithObjectWritable inputValue : values) {
                Object value = AdapterWithObjectWritable.fromWritableWithAdapter((HadoopWritableSerializationTool)this.serializationTool, (AdapterWithObjectWritable)inputValue);
                processor.add(inputValue.getDataId(), key.partitionData.isPrimary(), value);
            }
            this.preprocess(context, processor, summary);
            processor.process(this.createNeighborsListFactory(summary), new NNProcessor.CompleteNotifier<VALUEIN>(){

                public void complete(ByteArray id, VALUEIN value, NeighborList<VALUEIN> primaryList) throws IOException, InterruptedException {
                    context.progress();
                    this.processNeighbors(key.partitionData, id, value, primaryList, context, summary);
                    processor.remove(id);
                }
            });
            this.processSummary(key.partitionData, summary, context);
        }

        public NeighborListFactory<VALUEIN> createNeighborsListFactory(PARTITION_SUMMARY summary) {
            return new DefaultNeighborList.DefaultNeighborListFactory();
        }

        protected void preprocess(Reducer.Context context, NNProcessor<Object, VALUEIN> processor, PARTITION_SUMMARY summary) throws IOException, InterruptedException {
        }

        protected abstract PARTITION_SUMMARY createSummary();

        protected abstract void processSummary(Partitioner.PartitionData var1, PARTITION_SUMMARY var2, Reducer.Context var3) throws IOException, InterruptedException;

        protected Set<VALUEIN> createSetForNeighbors(boolean isSetForPrimary) {
            return new HashSet();
        }

        protected abstract void processNeighbors(Partitioner.PartitionData var1, ByteArray var2, VALUEIN var3, NeighborList<VALUEIN> var4, Reducer.Context var5, PARTITION_SUMMARY var6) throws IOException, InterruptedException;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), NNMapReduce.class, LOGGER);
            this.serializationTool = new HadoopWritableSerializationTool((JobContext)context);
            try {
                this.distanceFn = (DistanceFn)config.getInstance((Enum)CommonParameters.Common.DISTANCE_FUNCTION_CLASS, DistanceFn.class, FeatureGeometryDistanceFn.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IOException(e);
            }
            this.maxDistance = config.getDouble((Enum)PartitionParameters.Partition.MAX_DISTANCE, 1.0);
            try {
                LOGGER.info("Using secondary partitioning");
                this.partitioner = (Partitioner)config.getInstance((Enum)PartitionParameters.Partition.SECONDARY_PARTITIONER_CLASS, Partitioner.class, PassthruPartitioner.class);
                PartitionParameters.Partition.PARTITION_PRECISION.getHelper().setValue(context.getConfiguration(), NNMapReduce.class, (Object)new Double(1.0));
                this.partitioner.initialize((JobContext)context, NNMapReduce.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
            this.maxNeighbors = config.getInt((Enum)PartitionParameters.Partition.MAX_MEMBER_SELECTION, 75000);
            LOGGER.info("Maximum Neighbors = {}", (Object)this.maxNeighbors);
        }

        protected class LocalDistanceProfileGenerateFn
        implements DistanceProfileGenerateFn<Object, VALUEIN> {
            DistanceProfile<Object> singleNotThreadSafeImage = new DistanceProfile();

            protected LocalDistanceProfileGenerateFn() {
            }

            public DistanceProfile<Object> computeProfile(VALUEIN item1, VALUEIN item2) {
                this.singleNotThreadSafeImage.setDistance(NNReducer.this.distanceFn.measure(item1, item2));
                return this.singleNotThreadSafeImage;
            }
        }
    }

    public static class NNMapper<T>
    extends Mapper<GeoWaveInputKey, Object, PartitionDataWritable, AdapterWithObjectWritable> {
        protected Partitioner<T> partitioner;
        protected HadoopWritableSerializationTool serializationTool;
        protected final AdapterWithObjectWritable outputValue = new AdapterWithObjectWritable();
        protected final PartitionDataWritable partitionDataWritable = new PartitionDataWritable();

        protected void map(final GeoWaveInputKey key, Object value, final Mapper.Context context) throws IOException, InterruptedException {
            final Object unwrappedValue = value instanceof ObjectWritable ? this.serializationTool.fromWritable(key.getInternalAdapterId(), (ObjectWritable)value) : value;
            try {
                this.partitioner.partition(unwrappedValue, new Partitioner.PartitionDataCallback(){

                    public void partitionWith(Partitioner.PartitionData partitionData) throws Exception {
                        outputValue.setInternalAdapterId(key.getInternalAdapterId());
                        AdapterWithObjectWritable.fillWritableWithAdapter((HadoopWritableSerializationTool)serializationTool, (AdapterWithObjectWritable)outputValue, (short)key.getInternalAdapterId(), (ByteArray)key.getDataId(), (Object)unwrappedValue);
                        partitionDataWritable.setPartitionData(partitionData);
                        context.write((Object)partitionDataWritable, (Object)outputValue);
                    }
                });
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            ScopedJobConfiguration config = new ScopedJobConfiguration(context.getConfiguration(), NNMapReduce.class, LOGGER);
            this.serializationTool = new HadoopWritableSerializationTool((JobContext)context);
            try {
                this.partitioner = (Partitioner)config.getInstance((Enum)PartitionParameters.Partition.PARTITIONER_CLASS, Partitioner.class, OrthodromicDistancePartitioner.class);
                this.partitioner.initialize((JobContext)context, NNMapReduce.class);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }
}

