/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.operations;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.internal.Console;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.geowave.analytic.mapreduce.kde.KDECommandLineOptions;
import org.locationtech.geowave.analytic.mapreduce.kde.KDEJobRunner;
import org.locationtech.geowave.analytic.mapreduce.operations.AnalyticSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.cli.CLIUtils;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.util.DataStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"kde"}, parentOperation=AnalyticSection.class)
@Parameters(commandDescription="Kernel density estimate")
public class KdeCommand
extends ServiceEnabledCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KdeCommand.class);
    @Parameter(description="<input store name> <output store name>")
    private List<String> parameters = new ArrayList<String>();
    @ParametersDelegate
    private KDECommandLineOptions kdeOptions = new KDECommandLineOptions();
    private DataStorePluginOptions inputStoreOptions = null;
    private DataStorePluginOptions outputStoreOptions = null;

    public void execute(OperationParams params) throws Exception {
        this.computeResults(params);
    }

    public boolean runAsync() {
        return true;
    }

    public KDEJobRunner createRunner(OperationParams params) throws IOException {
        if (this.parameters.size() != 2) {
            throw new ParameterException("Requires arguments: <input store name> <output store name>");
        }
        String inputStore = this.parameters.get(0);
        String outputStore = this.parameters.get(1);
        File configFile = this.getGeoWaveConfigFile(params);
        Index outputPrimaryIndex = null;
        this.inputStoreOptions = CLIUtils.loadStore((String)inputStore, (File)configFile, (Console)params.getConsole());
        this.outputStoreOptions = CLIUtils.loadStore((String)outputStore, (File)configFile, (Console)params.getConsole());
        if (this.kdeOptions.getOutputIndex() != null && !this.kdeOptions.getOutputIndex().trim().isEmpty()) {
            String outputIndex = this.kdeOptions.getOutputIndex();
            List outputIndices = DataStoreUtils.loadIndices((IndexStore)this.outputStoreOptions.createIndexStore(), (String)outputIndex);
            for (Index primaryIndex : outputIndices) {
                if (SpatialDimensionalityTypeProvider.isSpatial((Index)primaryIndex)) {
                    outputPrimaryIndex = primaryIndex;
                    continue;
                }
                LOGGER.error("spatial temporal is not supported for output index. Only spatial index is supported.");
                throw new IOException("spatial temporal is not supported for output index. Only spatial index is supported.");
            }
        }
        KDEJobRunner runner = new KDEJobRunner(this.kdeOptions, this.inputStoreOptions, this.outputStoreOptions, configFile, outputPrimaryIndex);
        return runner;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(String inputStore, String outputStore) {
        this.parameters = new ArrayList<String>();
        this.parameters.add(inputStore);
        this.parameters.add(outputStore);
    }

    public KDECommandLineOptions getKdeOptions() {
        return this.kdeOptions;
    }

    public void setKdeOptions(KDECommandLineOptions kdeOptions) {
        this.kdeOptions = kdeOptions;
    }

    public DataStorePluginOptions getInputStoreOptions() {
        return this.inputStoreOptions;
    }

    public DataStorePluginOptions getOutputStoreOptions() {
        return this.outputStoreOptions;
    }

    public Void computeResults(OperationParams params) throws Exception {
        KDEJobRunner runner = this.createRunner(params);
        int status = runner.runJob();
        if (status != 0) {
            throw new RuntimeException("Failed to execute: " + status);
        }
        return null;
    }
}

