/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.operations;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.internal.Console;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.mapreduce.clustering.runner.MultiLevelKMeansClusteringJobRunner;
import org.locationtech.geowave.analytic.mapreduce.operations.AnalyticSection;
import org.locationtech.geowave.analytic.mapreduce.operations.options.CommonOptions;
import org.locationtech.geowave.analytic.mapreduce.operations.options.KMeansCommonOptions;
import org.locationtech.geowave.analytic.mapreduce.operations.options.KMeansParallelOptions;
import org.locationtech.geowave.analytic.mapreduce.operations.options.PropertyManagementConverter;
import org.locationtech.geowave.analytic.param.ExtractParameters;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.StoreParameters;
import org.locationtech.geowave.analytic.store.PersistableStore;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.store.cli.CLIUtils;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.mapreduce.operations.ConfigHDFSCommand;

@GeowaveOperation(name={"kmeansparallel"}, parentOperation=AnalyticSection.class)
@Parameters(commandDescription="KMeans parallel clustering")
public class KmeansParallelCommand
extends DefaultOperation
implements Command {
    @Parameter(description="<store name>")
    private List<String> parameters = new ArrayList<String>();
    @ParametersDelegate
    private CommonOptions commonOptions = new CommonOptions();
    @ParametersDelegate
    private KMeansCommonOptions kmeansCommonOptions = new KMeansCommonOptions();
    @ParametersDelegate
    private KMeansParallelOptions kmeansParallelOptions = new KMeansParallelOptions();
    DataStorePluginOptions inputStoreOptions = null;

    public void execute(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires arguments: <storename>");
        }
        String inputStoreName = this.parameters.get(0);
        File configFile = this.getGeoWaveConfigFile(params);
        if (this.commonOptions.getMapReduceHdfsHostPort() == null) {
            Properties configProperties = ConfigOptions.loadProperties((File)configFile);
            String hdfsFSUrl = ConfigHDFSCommand.getHdfsUrl((Properties)configProperties);
            this.commonOptions.setMapReduceHdfsHostPort(hdfsFSUrl);
        }
        this.inputStoreOptions = CLIUtils.loadStore((String)inputStoreName, (File)configFile, (Console)params.getConsole());
        PersistableStore persistedStore = new PersistableStore(this.inputStoreOptions);
        PropertyManagement properties = new PropertyManagement();
        properties.store((ParameterEnum)StoreParameters.StoreParam.INPUT_STORE, (Object)persistedStore);
        PropertyManagementConverter converter = new PropertyManagementConverter(properties);
        converter.readProperties(this.commonOptions);
        converter.readProperties(this.kmeansCommonOptions);
        converter.readProperties(this.kmeansParallelOptions);
        properties.store((ParameterEnum)ExtractParameters.Extract.QUERY, this.commonOptions.buildQuery());
        MultiLevelKMeansClusteringJobRunner runner = new MultiLevelKMeansClusteringJobRunner();
        int status = runner.run(properties);
        if (status != 0) {
            throw new RuntimeException("Failed to execute: " + status);
        }
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(String storeName) {
        this.parameters = new ArrayList<String>();
        this.parameters.add(storeName);
    }

    public CommonOptions getCommonOptions() {
        return this.commonOptions;
    }

    public void setCommonOptions(CommonOptions commonOptions) {
        this.commonOptions = commonOptions;
    }

    public KMeansCommonOptions getKmeansCommonOptions() {
        return this.kmeansCommonOptions;
    }

    public void setKmeansCommonOptions(KMeansCommonOptions kmeansCommonOptions) {
        this.kmeansCommonOptions = kmeansCommonOptions;
    }

    public DataStorePluginOptions getInputStoreOptions() {
        return this.inputStoreOptions;
    }

    public KMeansParallelOptions getKmeansParallelOptions() {
        return this.kmeansParallelOptions;
    }

    public void setKmeansParallelOptions(KMeansParallelOptions kmeansParallelOptions) {
        this.kmeansParallelOptions = kmeansParallelOptions;
    }
}

