/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.operations.options;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import org.locationtech.geowave.analytic.mapreduce.operations.options.QueryOptionsCommand;
import org.locationtech.geowave.analytic.param.CommonParameters;
import org.locationtech.geowave.analytic.param.ExtractParameters;
import org.locationtech.geowave.analytic.param.InputParameters;
import org.locationtech.geowave.analytic.param.MapReduceParameters;
import org.locationtech.geowave.analytic.param.OutputParameters;
import org.locationtech.geowave.analytic.param.annotations.CommonParameter;
import org.locationtech.geowave.analytic.param.annotations.ExtractParameter;
import org.locationtech.geowave.analytic.param.annotations.InputParameter;
import org.locationtech.geowave.analytic.param.annotations.MapReduceParameter;
import org.locationtech.geowave.analytic.param.annotations.OutputParameter;
import org.locationtech.geowave.core.cli.annotations.PrefixParameter;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;

public class CommonOptions {
    @MapReduceParameter(value={MapReduceParameters.MRConfig.CONFIG_FILE})
    @Parameter(names={"-conf", "--mapReduceConfigFile"}, description="MapReduce Configuration")
    private String mapReduceConfigFile;
    @MapReduceParameter(value={MapReduceParameters.MRConfig.HDFS_BASE_DIR})
    @Parameter(names={"-hdfsbase", "--mapReduceHdfsBaseDir"}, required=true, description="Fully qualified path to the base directory in hdfs")
    private String mapReduceHdfsBaseDir;
    @MapReduceParameter(value={MapReduceParameters.MRConfig.HDFS_HOST_PORT})
    @Parameter(names={"-hdfs", "--mapReduceHdfsHostPort"}, description="HDFS hostname and port in the format hostname:port")
    private String mapReduceHdfsHostPort;
    @MapReduceParameter(value={MapReduceParameters.MRConfig.JOBTRACKER_HOST_PORT})
    @Parameter(names={"-jobtracker", "--mapReduceJobtrackerHostPort"}, description="[REQUIRED (or resourceman)] Hadoop job tracker hostname and port in the format hostname:port")
    private String mapReduceJobtrackerHostPort;
    @MapReduceParameter(value={MapReduceParameters.MRConfig.YARN_RESOURCE_MANAGER})
    @Parameter(names={"-resourceman", "--mapReduceYarnResourceManager"}, description="[REQUIRED (or jobtracker)] Yarn resource manager hostname and port in the format hostname:port")
    private String mapReduceYarnResourceManager;
    @CommonParameter(value={CommonParameters.Common.DISTANCE_FUNCTION_CLASS})
    @Parameter(names={"-cdf", "--commonDistanceFunctionClass"}, description="Distance Function Class implements org.locationtech.geowave.analytics.distance.DistanceFn")
    private String commonDistanceFunctionClass;
    @ParametersDelegate
    @PrefixParameter(prefix="query")
    private QueryOptionsCommand queryOptions = new QueryOptionsCommand();
    @ExtractParameter(value={ExtractParameters.Extract.MAX_INPUT_SPLIT})
    @Parameter(names={"-emx", "--extractMaxInputSplit"}, required=true, description="Maximum hdfs input split size")
    private String extractMaxInputSplit;
    @ExtractParameter(value={ExtractParameters.Extract.MIN_INPUT_SPLIT})
    @Parameter(names={"-emn", "--extractMinInputSplit"}, required=true, description="Minimum hdfs input split size")
    private String extractMinInputSplit;
    @ExtractParameter(value={ExtractParameters.Extract.QUERY})
    @Parameter(names={"-eq", "--extractQuery"}, description="Query")
    private String extractQuery;
    @OutputParameter(value={OutputParameters.Output.OUTPUT_FORMAT})
    @Parameter(names={"-ofc", "--outputOutputFormat"}, description="Output Format Class")
    private String outputOutputFormat;
    @InputParameter(value={InputParameters.Input.INPUT_FORMAT})
    @Parameter(names={"-ifc", "--inputFormatClass"}, description="Input Format Class")
    private String inputFormatClass;
    @InputParameter(value={InputParameters.Input.HDFS_INPUT_PATH})
    @Parameter(names={"-iip", "--inputHdfsPath"}, hidden=true, description="Input Path")
    private String inputHdfsPath;
    @OutputParameter(value={OutputParameters.Output.REDUCER_COUNT})
    @Parameter(names={"-orc", "--outputReducerCount"}, description="Number of Reducers For Output")
    private String outputReducerCount;

    public String getCommonDistanceFunctionClass() {
        return this.commonDistanceFunctionClass;
    }

    public void setCommonDistanceFunctionClass(String commonDistanceFunctionClass) {
        this.commonDistanceFunctionClass = commonDistanceFunctionClass;
    }

    public QueryOptionsCommand getQueryOptions() {
        return this.queryOptions;
    }

    public void setQueryOptions(QueryOptionsCommand extractQueryOptions) {
        this.queryOptions = extractQueryOptions;
    }

    public String getExtractMaxInputSplit() {
        return this.extractMaxInputSplit;
    }

    public void setExtractMaxInputSplit(String extractMaxInputSplit) {
        this.extractMaxInputSplit = extractMaxInputSplit;
    }

    public String getExtractMinInputSplit() {
        return this.extractMinInputSplit;
    }

    public void setExtractMinInputSplit(String extractMinInputSplit) {
        this.extractMinInputSplit = extractMinInputSplit;
    }

    public String getExtractQuery() {
        return this.extractQuery;
    }

    public void setExtractQuery(String extractQuery) {
        this.extractQuery = extractQuery;
    }

    public String getOutputOutputFormat() {
        return this.outputOutputFormat;
    }

    public void setOutputOutputFormat(String outputOutputFormat) {
        this.outputOutputFormat = outputOutputFormat;
    }

    public String getOutputReducerCount() {
        return this.outputReducerCount;
    }

    public void setOutputReducerCount(String outputReducerCount) {
        this.outputReducerCount = outputReducerCount;
    }

    public String getInputFormatClass() {
        return this.inputFormatClass;
    }

    public void setInputFormatClass(String inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public String getInputHdfsPath() {
        return this.inputHdfsPath;
    }

    public void setInputHdfsPath(String inputHdfsPath) {
        this.inputHdfsPath = inputHdfsPath;
    }

    public Query<?> buildQuery() {
        QueryBuilder bldr = QueryBuilder.newBuilder();
        if (this.queryOptions.getTypeNames() != null && this.queryOptions.getTypeNames().length > 0) {
            bldr.setTypeNames(this.queryOptions.getTypeNames());
        }
        if (this.queryOptions.getAuthorizations() != null) {
            bldr.setAuthorizations(this.queryOptions.getAuthorizations());
        }
        if (this.queryOptions.getIndexName() != null) {
            bldr.indexName(this.queryOptions.getIndexName());
        }
        return (Query)bldr.build();
    }

    public String getMapReduceConfigFile() {
        return this.mapReduceConfigFile;
    }

    public void setMapReduceConfigFile(String mapReduceConfigFile) {
        this.mapReduceConfigFile = mapReduceConfigFile;
    }

    public String getMapReduceHdfsBaseDir() {
        return this.mapReduceHdfsBaseDir;
    }

    public void setMapReduceHdfsBaseDir(String mapReduceHdfsBaseDir) {
        this.mapReduceHdfsBaseDir = mapReduceHdfsBaseDir;
    }

    public String getMapReduceHdfsHostPort() {
        return this.mapReduceHdfsHostPort;
    }

    public void setMapReduceHdfsHostPort(String mapReduceHdfsHostPort) {
        this.mapReduceHdfsHostPort = mapReduceHdfsHostPort;
    }

    public String getMapReduceJobtrackerHostPort() {
        return this.mapReduceJobtrackerHostPort;
    }

    public void setMapReduceJobtrackerHostPort(String mapReduceJobtrackerHostPort) {
        this.mapReduceJobtrackerHostPort = mapReduceJobtrackerHostPort;
    }

    public String getMapReduceYarnResourceManager() {
        return this.mapReduceYarnResourceManager;
    }

    public void setMapReduceYarnResourceManager(String mapReduceYarnResourceManager) {
        this.mapReduceYarnResourceManager = mapReduceYarnResourceManager;
    }
}

