/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.operations.options;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import org.locationtech.geowave.analytic.param.JumpParameters;
import org.locationtech.geowave.analytic.param.SampleParameters;
import org.locationtech.geowave.analytic.param.annotations.JumpParameter;
import org.locationtech.geowave.analytic.param.annotations.SampleParameter;
import org.locationtech.geowave.core.index.numeric.NumericRange;

public class KMeansJumpOptions {
    @JumpParameter(value={JumpParameters.Jump.KPLUSPLUS_MIN})
    @Parameter(names={"-jkp", "--jumpKplusplusMin"}, required=true, description="The minimum k when K means ++ takes over sampling.")
    private String jumpKplusplusMin;
    @JumpParameter(value={JumpParameters.Jump.RANGE_OF_CENTROIDS})
    @Parameter(names={"-jrc", "--jumpRangeOfCentroids"}, required=true, description="Comma-separated range of centroids (e.g. 2,100)", converter=NumericRangeConverter.class)
    private NumericRange jumpRangeOfCentroids;
    @SampleParameter(value={SampleParameters.Sample.SAMPLE_RANK_FUNCTION})
    @Parameter(names={"-srf", "--sampleSampleRankFunction"}, hidden=true, description="The rank function used when sampling the first N highest rank items.")
    private String sampleSampleRankFunction;
    @SampleParameter(value={SampleParameters.Sample.SAMPLE_SIZE})
    @Parameter(names={"-sss", "--sampleSampleSize"}, hidden=true, description="Sample Size")
    private String sampleSampleSize;

    public String getJumpKplusplusMin() {
        return this.jumpKplusplusMin;
    }

    public void setJumpKplusplusMin(String jumpKplusplusMin) {
        this.jumpKplusplusMin = jumpKplusplusMin;
    }

    public NumericRange getJumpRangeOfCentroids() {
        return this.jumpRangeOfCentroids;
    }

    public void setJumpRangeOfCentroids(NumericRange jumpRangeOfCentroids) {
        this.jumpRangeOfCentroids = jumpRangeOfCentroids;
    }

    public String getSampleSampleRankFunction() {
        return this.sampleSampleRankFunction;
    }

    public void setSampleSampleRankFunction(String sampleSampleRankFunction) {
        this.sampleSampleRankFunction = sampleSampleRankFunction;
    }

    public String getSampleSampleSize() {
        return this.sampleSampleSize;
    }

    public void setSampleSampleSize(String sampleSampleSize) {
        this.sampleSampleSize = sampleSampleSize;
    }

    public static class NumericRangeConverter
    implements IStringConverter<NumericRange> {
        public NumericRange convert(String value) {
            String p = value.toString();
            String[] parts = p.split(",");
            try {
                if (parts.length == 2) {
                    return new NumericRange(Double.parseDouble(parts[0].trim()), Double.parseDouble(parts[1].trim()));
                }
                return new NumericRange(0.0, Double.parseDouble(p));
            }
            catch (Exception ex) {
                throw new ParameterException("Invalid range parameter " + value, (Throwable)ex);
            }
        }
    }
}

