/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce.operations.options;

import java.lang.reflect.AnnotatedElement;
import org.locationtech.geowave.analytic.PropertyManagement;
import org.locationtech.geowave.analytic.param.ParameterEnum;
import org.locationtech.geowave.analytic.param.annotations.CentroidParameter;
import org.locationtech.geowave.analytic.param.annotations.ClusteringParameter;
import org.locationtech.geowave.analytic.param.annotations.CommonParameter;
import org.locationtech.geowave.analytic.param.annotations.ExtractParameter;
import org.locationtech.geowave.analytic.param.annotations.GlobalParameter;
import org.locationtech.geowave.analytic.param.annotations.HullParameter;
import org.locationtech.geowave.analytic.param.annotations.InputParameter;
import org.locationtech.geowave.analytic.param.annotations.JumpParameter;
import org.locationtech.geowave.analytic.param.annotations.MapReduceParameter;
import org.locationtech.geowave.analytic.param.annotations.OutputParameter;
import org.locationtech.geowave.analytic.param.annotations.PartitionParameter;
import org.locationtech.geowave.analytic.param.annotations.SampleParameter;
import org.locationtech.geowave.core.cli.prefix.JCommanderPrefixTranslator;
import org.locationtech.geowave.core.cli.prefix.JCommanderTranslationMap;
import org.locationtech.geowave.core.cli.prefix.TranslationEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyManagementConverter {
    static final Logger LOGGER = LoggerFactory.getLogger(PropertyManagementConverter.class);
    final PropertyManagement properties;

    public PropertyManagementConverter(PropertyManagement properties) {
        this.properties = properties;
    }

    public PropertyManagement getProperties() {
        return this.properties;
    }

    public void readProperties(Object object) {
        JCommanderPrefixTranslator translator = new JCommanderPrefixTranslator();
        translator.addObject(object);
        JCommanderTranslationMap map = translator.translate();
        for (TranslationEntry entry : map.getEntries().values()) {
            AnnotatedElement element = entry.getMember();
            CentroidParameter centroid = element.getAnnotation(CentroidParameter.class);
            ClusteringParameter clustering = element.getAnnotation(ClusteringParameter.class);
            CommonParameter common = element.getAnnotation(CommonParameter.class);
            ExtractParameter extract = element.getAnnotation(ExtractParameter.class);
            GlobalParameter global = element.getAnnotation(GlobalParameter.class);
            HullParameter hull = element.getAnnotation(HullParameter.class);
            InputParameter input = element.getAnnotation(InputParameter.class);
            JumpParameter jump = element.getAnnotation(JumpParameter.class);
            MapReduceParameter mapReduce = element.getAnnotation(MapReduceParameter.class);
            OutputParameter output = element.getAnnotation(OutputParameter.class);
            PartitionParameter partition = element.getAnnotation(PartitionParameter.class);
            SampleParameter sample = element.getAnnotation(SampleParameter.class);
            if (centroid != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])centroid.value());
            }
            if (clustering != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])clustering.value());
            }
            if (common != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])common.value());
            }
            if (extract != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])extract.value());
            }
            if (global != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])global.value());
            }
            if (hull != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])hull.value());
            }
            if (input != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])input.value());
            }
            if (jump != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])jump.value());
            }
            if (mapReduce != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])mapReduce.value());
            }
            if (output != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])output.value());
            }
            if (partition != null) {
                this.handleEnum(entry, (ParameterEnum<?>[])partition.value());
            }
            if (sample == null) continue;
            this.handleEnum(entry, (ParameterEnum<?>[])sample.value());
        }
    }

    private void handleEnum(TranslationEntry entry, ParameterEnum<?>[] enumVals) {
        Object value = entry.getParam().get(entry.getObject());
        if (value != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Analytic Property Value: %s = %s", entry.getAsPropertyName(), value.toString()));
            }
            for (ParameterEnum<?> enumVal : enumVals) {
                enumVal.getHelper().setValue(this.properties, value);
            }
        }
    }
}

