/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.accumulo.cli;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.locationtech.geowave.core.store.util.ClasspathUtils;
import org.locationtech.geowave.datastore.accumulo.cli.GeoWaveMiniAccumuloClusterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloClusterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiniAccumuloClusterFactory.class);
    protected static final String HADOOP_WINDOWS_UTIL = "winutils.exe";

    protected static boolean isYarn() {
        return VersionUtil.compareVersions((String)VersionInfo.getVersion(), (String)"2.2.0") >= 0;
    }

    public static MiniAccumuloClusterImpl newAccumuloCluster(MiniAccumuloConfigImpl config, Class context, URL ... additionalClasspathUrls) throws IOException {
        String jarPath = ClasspathUtils.setupPathingJarClassPath((File)config.getDir(), (Class)context, (URL[])additionalClasspathUrls);
        if (jarPath == null) {
            return null;
        }
        config.setClasspathItems(new String[]{jarPath});
        GeoWaveMiniAccumuloClusterImpl retVal = new GeoWaveMiniAccumuloClusterImpl(config);
        if (SystemUtils.IS_OS_WINDOWS && MiniAccumuloClusterFactory.isYarn()) {
            File binDir;
            File hadoopDir;
            LOGGER.info("Running YARN on windows requires a local installation of Hadoop");
            LOGGER.info("'HADOOP_HOME' must be set and 'PATH' must contain %HADOOP_HOME%/bin");
            Map<String, String> env = System.getenv();
            String hadoopHome = System.getProperty("hadoop.home.dir");
            if (hadoopHome == null) {
                hadoopHome = env.get("HADOOP_HOME");
            }
            boolean success = false;
            if (hadoopHome != null && (hadoopDir = new File(hadoopHome)).exists() && (binDir = new File(config.getDir(), "bin")).mkdir()) {
                FileUtils.copyFile((File)new File(hadoopDir + File.separator + "bin", HADOOP_WINDOWS_UTIL), (File)new File(binDir, HADOOP_WINDOWS_UTIL));
                success = true;
            }
            if (!success) {
                LOGGER.error("'HADOOP_HOME' environment variable is not set or <HADOOP_HOME>/bin/winutils.exe does not exist");
                return retVal;
            }
        }
        return retVal;
    }
}

