/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.accumulo.cli;

import com.google.common.io.Files;
import java.io.File;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.apache.accumulo.monitor.Monitor;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.apache.log4j.Level;
import org.locationtech.geowave.datastore.accumulo.cli.MiniAccumuloClusterFactory;
import org.locationtech.geowave.datastore.accumulo.cli.MiniAccumuloUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloMiniCluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccumuloMiniCluster.class);

    protected static boolean isYarn() {
        return VersionUtil.compareVersions((String)VersionInfo.getVersion(), (String)"2.2.0") >= 0;
    }

    public static void main(String[] args) throws Exception {
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
        boolean interactive = System.getProperty("interactive") != null ? Boolean.parseBoolean(System.getProperty("interactive")) : true;
        String password = System.getProperty("password", "secret");
        String user = System.getProperty("rootUser", "root");
        File tempDir = Files.createTempDir();
        String instanceName = System.getProperty("instanceName", "accumulo");
        MiniAccumuloConfig miniAccumuloConfig = new MiniAccumuloConfig(tempDir, password).setNumTservers(2).setInstanceName(instanceName).setZooKeeperPort(2181);
        MiniAccumuloUtils.setRootUserName(miniAccumuloConfig, user);
        MiniAccumuloUtils.setProperty(miniAccumuloConfig, Property.MONITOR_PORT, "9995");
        final MiniAccumuloCluster accumulo = MiniAccumuloClusterFactory.newAccumuloCluster(miniAccumuloConfig, AccumuloMiniCluster.class, new URL[0]);
        accumulo.start();
        MiniAccumuloUtils.exec(accumulo, Monitor.class, new String[0]);
        System.out.println("starting up ...");
        Thread.sleep(3000L);
        System.out.println("cluster running with root user " + user + ", password " + password + ", instance name " + accumulo.getInstanceName() + ", and zookeeper " + accumulo.getZooKeepers());
        if (!interactive) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        accumulo.stop();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to shutdown Accumulo", (Throwable)e);
                        System.out.println("Error shutting down Accumulo.");
                    }
                    System.out.println("Shutting down!");
                }
            });
            while (true) {
                Thread.sleep(TimeUnit.MILLISECONDS.convert(Long.MAX_VALUE, TimeUnit.DAYS));
            }
        }
        System.out.println("Press Enter to shutdown..");
        System.in.read();
        System.out.println("Shutting down!");
        accumulo.stop();
    }
}

