/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.accumulo.cli;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiniAccumuloUtils.class);

    public static void setClasspathItems(MiniAccumuloConfig config, String ... classpathItems) {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            impl.getType().getMethod("setClasspathItems", String[].class).invoke(impl.get(config), new Object[]{classpathItems});
        }
        catch (Exception e) {
            LOGGER.warn("Unable to setClasspathItems", (Throwable)e);
        }
    }

    public static void setRootUserName(MiniAccumuloConfig config, String rootUserName) {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            impl.getType().getMethod("setRootUserName", String.class).invoke(impl.get(config), rootUserName);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to setRootUserName", (Throwable)e);
        }
    }

    public static Object getClientProperty(String name) {
        try {
            return MiniAccumuloUtils.class.getClassLoader().loadClass("org.apache.accumulo.core.conf.ClientProperty").getDeclaredMethod("valueOf", String.class).invoke(null, name);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to getClientProperty", (Throwable)e);
            return null;
        }
    }

    public static void setClientProperty(MiniAccumuloConfig config, Object property, String value) {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            impl.getType().getMethod("setClientProperty", MiniAccumuloUtils.class.getClassLoader().loadClass("org.apache.accumulo.core.conf.ClientProperty"), String.class).invoke(impl.get(config), property, value);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to setClientProperty", (Throwable)e);
        }
    }

    public static void setProperty(MiniAccumuloConfig config, Property property, String value) {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            impl.getType().getMethod("setProperty", Property.class, String.class).invoke(impl.get(config), property, value);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to setProperty", (Throwable)e);
        }
    }

    public static Map<String, String> getSiteConfig(MiniAccumuloConfig config) {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            return (Map)impl.getType().getMethod("getSiteConfig", new Class[0]).invoke(impl.get(config), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to getSiteConfig", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getSystemProperties(MiniAccumuloConfig config) {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            return (Map)impl.getType().getMethod("getSystemProperties", new Class[0]).invoke(impl.get(config), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to getSystemProperties", (Throwable)e);
            return null;
        }
    }

    public static void setSystemProperties(MiniAccumuloConfig config, Map<String, String> systemProperties) {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            impl.getType().getMethod("setSystemProperties", Map.class).invoke(impl.get(config), systemProperties);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to setSystemProperties", (Throwable)e);
        }
    }

    public static File getConfDir(MiniAccumuloConfig config) throws IOException {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            return (File)impl.getType().getMethod("getConfDir", new Class[0]).invoke(impl.get(config), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to getConfDir", (Throwable)e);
            return null;
        }
    }

    public static File getLogDir(MiniAccumuloConfig config) throws IOException {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            return (File)impl.getType().getMethod("getLogDir", new Class[0]).invoke(impl.get(config), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to getLogDir", (Throwable)e);
            return null;
        }
    }

    public static String getZooKeepers(MiniAccumuloConfig config) throws IOException {
        try {
            Field impl = MiniAccumuloConfig.class.getDeclaredField("impl");
            impl.setAccessible(true);
            return (String)impl.getType().getMethod("getZooKeepers", new Class[0]).invoke(impl.get(config), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to getZooKeepers", (Throwable)e);
            return null;
        }
    }

    public static Process exec(MiniAccumuloCluster cluster, Class<?> clazz, String ... args) throws IOException {
        return MiniAccumuloUtils.exec(cluster, clazz, null, args);
    }

    public static Process exec(MiniAccumuloCluster cluster, Class<?> clazz, List<String> jvmArgs, String ... args) throws IOException {
        try {
            Field impl = MiniAccumuloCluster.class.getDeclaredField("impl");
            impl.setAccessible(true);
            Object obj = impl.getType().getMethod("exec", Class.class, List.class, String[].class).invoke(impl.get(cluster), clazz, jvmArgs, args);
            if (obj instanceof Process) {
                return (Process)obj;
            }
            return (Process)obj.getClass().getMethod("getProcess", new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Unable start process for " + clazz, (Throwable)e);
            return null;
        }
    }
}

