/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.schemabuilder.Create;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.locationtech.geowave.core.store.entities.GeoWaveValue;
import org.locationtech.geowave.core.store.entities.GeoWaveValueImpl;
import org.locationtech.geowave.core.store.entities.MergeableGeoWaveRow;

public class CassandraRow
extends MergeableGeoWaveRow {
    private static final Logger LOGGER = Logger.getLogger(CassandraRow.class);
    private final Row row;

    public CassandraRow() {
        super(new GeoWaveValue[0]);
        this.row = null;
    }

    public CassandraRow(Row row) {
        super(CassandraRow.getFieldValues(row));
        this.row = row;
    }

    public byte[] getDataId() {
        return this.row.getBytes(CassandraField.GW_DATA_ID_KEY.getFieldName()).array();
    }

    public byte[] getSortKey() {
        return this.row.getBytes(CassandraField.GW_SORT_KEY.getFieldName()).array();
    }

    public byte[] getPartitionKey() {
        return this.row.getBytes(CassandraField.GW_PARTITION_ID_KEY.getFieldName()).array();
    }

    public int getNumberOfDuplicates() {
        return this.row.getByte(CassandraField.GW_NUM_DUPLICATES_KEY.getFieldName());
    }

    private static GeoWaveValue[] getFieldValues(Row row) {
        byte[] fieldMask = row.getBytes(CassandraField.GW_FIELD_MASK_KEY.getFieldName()).array();
        byte[] value = row.getBytes(CassandraField.GW_VALUE_KEY.getFieldName()).array();
        byte[] visibility = row.getBytes(CassandraField.GW_FIELD_VISIBILITY_KEY.getFieldName()).array();
        GeoWaveValueImpl[] fieldValues = new GeoWaveValueImpl[]{new GeoWaveValueImpl(fieldMask, visibility, value)};
        return fieldValues;
    }

    public short getAdapterId() {
        return this.row.getShort(CassandraField.GW_ADAPTER_ID_KEY.getFieldName());
    }

    public static enum CassandraField {
        GW_PARTITION_ID_KEY("partition", DataType.blob(), ColumnType.PARTITION_KEY, true),
        GW_ADAPTER_ID_KEY("adapter_id", DataType.smallint(), ColumnType.CLUSTER_COLUMN, true),
        GW_SORT_KEY("sort", DataType.blob(), ColumnType.CLUSTER_COLUMN),
        GW_DATA_ID_KEY("data_id", DataType.blob(), ColumnType.CLUSTER_COLUMN),
        GW_FIELD_VISIBILITY_KEY("vis", DataType.blob(), ColumnType.CLUSTER_COLUMN),
        GW_NANO_TIME_KEY("nano_time", DataType.blob(), ColumnType.CLUSTER_COLUMN),
        GW_FIELD_MASK_KEY("field_mask", DataType.blob(), ColumnType.OTHER_COLUMN),
        GW_VALUE_KEY("value", DataType.blob(), ColumnType.OTHER_COLUMN, true),
        GW_NUM_DUPLICATES_KEY("num_duplicates", DataType.tinyint(), ColumnType.OTHER_COLUMN);

        private final String fieldName;
        private final DataType dataType;
        private ColumnType columnType;
        private final boolean isDataIndexColumn;

        private CassandraField(String fieldName, DataType dataType, ColumnType columnType) {
            this(fieldName, dataType, columnType, false);
        }

        private CassandraField(String fieldName, DataType dataType, ColumnType columnType, boolean isDataIndexColumn) {
            this.fieldName = fieldName;
            this.dataType = dataType;
            this.columnType = columnType;
            this.isDataIndexColumn = isDataIndexColumn;
        }

        public boolean isDataIndexColumn() {
            return this.isDataIndexColumn;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getBindMarkerName() {
            return this.fieldName + "_val";
        }

        public String getLowerBoundBindMarkerName() {
            return this.fieldName + "_min";
        }

        public String getUpperBoundBindMarkerName() {
            return this.fieldName + "_max";
        }

        public void addColumn(Create create) {
            this.columnType.createFunction.accept(create, Pair.of((Object)this.fieldName, (Object)this.dataType));
        }
    }

    private static enum ColumnType {
        PARTITION_KEY((c, f) -> c.addPartitionKey((String)f.getLeft(), (DataType)f.getRight())),
        CLUSTER_COLUMN((c, f) -> c.addClusteringColumn((String)f.getLeft(), (DataType)f.getRight())),
        OTHER_COLUMN((c, f) -> {
            Create cfr_ignored_0 = (Create)c.addColumn((String)f.getLeft(), (DataType)f.getRight());
        });

        private BiConsumer<Create, Pair<String, DataType>> createFunction;

        private ColumnType(BiConsumer<Create, Pair<String, DataType>> createFunction) {
            this.createFunction = createFunction;
        }
    }
}

