/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;

public class BatchHandler {
    protected final Session session;
    private final BatchStatement.Type type = BatchStatement.Type.UNLOGGED;
    protected final Map<ByteArray, BatchStatement> batches = new HashMap<ByteArray, BatchStatement>();

    public BatchHandler(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchStatement addStatement(GeoWaveRow row, Statement statement) {
        ByteArray partition = new ByteArray(row.getPartitionKey());
        BatchStatement tokenBatch = this.batches.get(partition);
        if (tokenBatch == null) {
            tokenBatch = new BatchStatement(this.type);
            this.batches.put(partition, tokenBatch);
        }
        BatchStatement batchStatement = tokenBatch;
        synchronized (batchStatement) {
            tokenBatch.add(statement);
        }
        return tokenBatch;
    }
}

