/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.datastore.cassandra.operations.BatchHandler;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraOperations;
import org.locationtech.geowave.datastore.cassandra.util.CassandraUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedWrite
extends BatchHandler
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchedWrite.class);
    private static final boolean ASYNC = true;
    private final int batchSize;
    private final PreparedStatement preparedInsert;
    private static final int MAX_CONCURRENT_WRITE = 100;
    private final Semaphore writeSemaphore = new Semaphore(100);
    private final boolean isDataIndex;
    private final boolean visibilityEnabled;

    public BatchedWrite(Session session, PreparedStatement preparedInsert, int batchSize, boolean isDataIndex, boolean visibilityEnabled) {
        super(session);
        this.preparedInsert = preparedInsert;
        this.batchSize = batchSize;
        this.isDataIndex = isDataIndex;
        this.visibilityEnabled = visibilityEnabled;
    }

    public void insert(GeoWaveRow row) {
        BoundStatement[] statements;
        for (BoundStatement statement : statements = CassandraUtils.bindInsertion(this.preparedInsert, row, this.isDataIndex, this.visibilityEnabled)) {
            this.insertStatement(row, statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertStatement(GeoWaveRow row, BoundStatement statement) {
        if (this.batchSize > 1) {
            BatchStatement currentBatch;
            BatchStatement batchStatement = currentBatch = this.addStatement(row, (Statement)statement);
            synchronized (batchStatement) {
                if (currentBatch.size() >= this.batchSize) {
                    this.writeBatch(currentBatch);
                }
            }
        }
        try {
            this.executeAsync((Statement)statement);
        }
        catch (InterruptedException e) {
            LOGGER.warn("async write semaphore interrupted", (Throwable)e);
            this.writeSemaphore.release();
        }
    }

    private void writeBatch(BatchStatement batch) {
        try {
            this.executeAsync((Statement)batch);
            batch.clear();
        }
        catch (InterruptedException e) {
            LOGGER.warn("async batch write semaphore interrupted", (Throwable)e);
            this.writeSemaphore.release();
        }
    }

    private void executeAsync(Statement statement) throws InterruptedException {
        this.writeSemaphore.acquire();
        ResultSetFuture future = this.session.executeAsync(statement);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new IngestCallback(this.writeSemaphore), (Executor)CassandraOperations.WRITE_RESPONSE_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Iterator iterator = this.batches.values().iterator();
        while (iterator.hasNext()) {
            BatchStatement batch;
            BatchStatement batchStatement = batch = (BatchStatement)iterator.next();
            synchronized (batchStatement) {
                this.writeBatch(batch);
            }
        }
        this.writeSemaphore.acquire(100);
        this.writeSemaphore.release(100);
    }

    protected static class IngestCallback
    implements FutureCallback<ResultSet> {
        private final Semaphore semaphore;

        public IngestCallback(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        public void onSuccess(ResultSet result) {
            this.semaphore.release();
        }

        public void onFailure(Throwable t) {
            this.semaphore.release();
            throw new RuntimeException(t);
        }
    }
}

