/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.nio.ByteBuffer;
import org.locationtech.geowave.core.store.operations.MetadataDeleter;
import org.locationtech.geowave.core.store.operations.MetadataQuery;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraOperations;

public class CassandraMetadataDeleter
implements MetadataDeleter {
    private final CassandraOperations operations;
    private final MetadataType metadataType;

    public CassandraMetadataDeleter(CassandraOperations operations, MetadataType metadataType) {
        this.operations = operations;
        this.metadataType = metadataType;
    }

    public void close() throws Exception {
    }

    public boolean delete(MetadataQuery query) {
        Delete delete = this.operations.getDelete(this.operations.getMetadataTableName(this.metadataType));
        if (query.hasPrimaryId()) {
            Delete.Where where = delete.where(QueryBuilder.eq((String)"I", (Object)ByteBuffer.wrap(query.getPrimaryId())));
            if (query.hasSecondaryId()) {
                where.and(QueryBuilder.eq((String)"S", (Object)ByteBuffer.wrap(query.getSecondaryId())));
            }
        }
        this.operations.getSession().execute((Statement)delete);
        return true;
    }

    public void flush() {
    }
}

