/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.bouncycastle.util.Arrays;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.entities.GeoWaveMetadata;
import org.locationtech.geowave.core.store.operations.MetadataQuery;
import org.locationtech.geowave.core.store.operations.MetadataReader;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.core.store.util.StatisticsRowIterator;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraOperations;

public class CassandraMetadataReader
implements MetadataReader {
    private final CassandraOperations operations;
    private final MetadataType metadataType;

    public CassandraMetadataReader(CassandraOperations operations, MetadataType metadataType) {
        this.operations = operations;
        this.metadataType = metadataType;
    }

    public CloseableIterator<GeoWaveMetadata> query(MetadataQuery query) {
        String tableName = this.operations.getMetadataTableName(this.metadataType);
        String[] selectedColumns = this.getSelectedColumns(query);
        if (MetadataType.STATS.equals((Object)this.metadataType)) {
            selectedColumns = Arrays.append((String[])selectedColumns, (String)"A");
        }
        Select select = this.operations.getSelect(tableName, selectedColumns);
        if (query.hasPrimaryId()) {
            Select.Where where = select.where(QueryBuilder.eq((String)"I", (Object)ByteBuffer.wrap(query.getPrimaryId())));
            if (query.hasSecondaryId()) {
                where.and(QueryBuilder.eq((String)"S", (Object)ByteBuffer.wrap(query.getSecondaryId())));
            }
        } else if (query.hasSecondaryId()) {
            select.allowFiltering().where(QueryBuilder.eq((String)"S", (Object)ByteBuffer.wrap(query.getSecondaryId())));
        }
        ResultSet rs = this.operations.getSession().execute((Statement)select);
        CloseableIterator.Wrapper retVal = new CloseableIterator.Wrapper(Iterators.transform((Iterator)rs.iterator(), result -> new GeoWaveMetadata(query.hasPrimaryId() ? query.getPrimaryId() : ((ByteBuffer)result.get("I", ByteBuffer.class)).array(), this.useSecondaryId(query) ? query.getSecondaryId() : ((ByteBuffer)result.get("S", ByteBuffer.class)).array(), this.getVisibility((Row)result), ((ByteBuffer)result.get("V", ByteBuffer.class)).array())));
        return MetadataType.STATS.equals((Object)this.metadataType) ? new StatisticsRowIterator((CloseableIterator)retVal, query.getAuthorizations()) : retVal;
    }

    private byte[] getVisibility(Row result) {
        ByteBuffer buf;
        if (MetadataType.STATS.equals((Object)this.metadataType) && (buf = (ByteBuffer)result.get("A", ByteBuffer.class)) != null) {
            return buf.array();
        }
        return null;
    }

    private String[] getSelectedColumns(MetadataQuery query) {
        if (query.hasPrimaryId()) {
            if (this.useSecondaryId(query)) {
                return new String[]{"V"};
            }
            return new String[]{"S", "V"};
        }
        if (this.useSecondaryId(query)) {
            return new String[]{"I", "V"};
        }
        return new String[]{"I", "S", "V"};
    }

    private boolean useSecondaryId(MetadataQuery query) {
        return !MetadataType.STATS.equals((Object)this.metadataType) && !MetadataType.INTERNAL_ADAPTER.equals((Object)this.metadataType) || query.hasSecondaryId();
    }
}

