/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.nio.ByteBuffer;
import org.locationtech.geowave.core.store.entities.GeoWaveMetadata;
import org.locationtech.geowave.core.store.operations.MetadataWriter;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraOperations;

public class CassandraMetadataWriter
implements MetadataWriter {
    protected static final String PRIMARY_ID_KEY = "I";
    protected static final String SECONDARY_ID_KEY = "S";
    protected static final String TIMESTAMP_ID_KEY = "T";
    protected static final String VISIBILITY_KEY = "A";
    protected static final String VALUE_KEY = "V";
    private final CassandraOperations operations;
    private final String tableName;

    public CassandraMetadataWriter(CassandraOperations operations, String tableName) {
        this.operations = operations;
        this.tableName = tableName;
    }

    public void close() throws Exception {
    }

    public void write(GeoWaveMetadata metadata) {
        Insert insert = this.operations.getInsert(this.tableName);
        insert.value(PRIMARY_ID_KEY, (Object)ByteBuffer.wrap(metadata.getPrimaryId()));
        if (metadata.getSecondaryId() != null) {
            insert.value(SECONDARY_ID_KEY, (Object)ByteBuffer.wrap(metadata.getSecondaryId()));
            insert.value(TIMESTAMP_ID_KEY, QueryBuilder.now());
            if (metadata.getVisibility() != null && metadata.getVisibility().length > 0) {
                insert.value(VISIBILITY_KEY, (Object)ByteBuffer.wrap(metadata.getVisibility()));
            }
        }
        insert.value(VALUE_KEY, (Object)ByteBuffer.wrap(metadata.getValue()));
        this.operations.getSession().execute((Statement)insert);
    }

    public void flush() {
    }
}

