/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.ByteArrayRange;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.SinglePartitionQueryRanges;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.store.BaseDataStoreOptions;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.base.dataidx.DataIndexUtils;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveRowIteratorTransformer;
import org.locationtech.geowave.core.store.operations.DataIndexReaderParams;
import org.locationtech.geowave.core.store.operations.MetadataDeleter;
import org.locationtech.geowave.core.store.operations.MetadataReader;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.core.store.operations.MetadataWriter;
import org.locationtech.geowave.core.store.operations.ReaderParams;
import org.locationtech.geowave.core.store.operations.RowDeleter;
import org.locationtech.geowave.core.store.operations.RowReader;
import org.locationtech.geowave.core.store.operations.RowReaderWrapper;
import org.locationtech.geowave.core.store.operations.RowWriter;
import org.locationtech.geowave.core.store.query.filter.ClientVisibilityFilter;
import org.locationtech.geowave.datastore.cassandra.CassandraRow;
import org.locationtech.geowave.datastore.cassandra.config.CassandraOptions;
import org.locationtech.geowave.datastore.cassandra.config.CassandraRequiredOptions;
import org.locationtech.geowave.datastore.cassandra.operations.BatchedRangeRead;
import org.locationtech.geowave.datastore.cassandra.operations.BatchedWrite;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraDeleter;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraMetadataDeleter;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraMetadataReader;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraMetadataWriter;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraReader;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraWriter;
import org.locationtech.geowave.datastore.cassandra.util.KeyspaceStatePool;
import org.locationtech.geowave.datastore.cassandra.util.SessionPool;
import org.locationtech.geowave.mapreduce.MapReduceDataStoreOperations;
import org.locationtech.geowave.mapreduce.splits.RecordReaderParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraOperations
implements MapReduceDataStoreOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraOperations.class);
    private final Session session;
    private final String gwNamespace;
    private static final int WRITE_RESPONSE_THREAD_SIZE = 16;
    private static final int READ_RESPONSE_THREAD_SIZE = 16;
    protected static final ExecutorService WRITE_RESPONSE_THREADS = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(16)));
    protected static final ExecutorService READ_RESPONSE_THREADS = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(16)));
    private static final Object CREATE_TABLE_MUTEX = new Object();
    private final CassandraOptions options;
    private final KeyspaceStatePool.KeyspaceState state;

    public CassandraOperations(CassandraRequiredOptions options) {
        this.gwNamespace = options.getGeoWaveNamespace() == null || options.getGeoWaveNamespace().equals("") ? "geowave" : CassandraOperations.getCassandraSafeName(options.getGeoWaveNamespace());
        this.session = SessionPool.getInstance().getSession(options.getContactPoint());
        this.state = KeyspaceStatePool.getInstance().getCachedState(options.getContactPoint(), this.gwNamespace);
        this.options = (CassandraOptions)options.getStoreOptions();
        this.initKeyspace();
    }

    private static String getCassandraSafeName(String name) {
        return name.replaceAll("[^a-zA-Z\\d_]", "_");
    }

    public void initKeyspace() {
        this.session.execute((Statement)SchemaBuilder.createKeyspace((String)this.gwNamespace).ifNotExists().with().replication((Map)ImmutableMap.of((Object)"class", (Object)"SimpleStrategy", (Object)"replication_factor", (Object)this.options.getReplicationFactor())).durableWrites(Boolean.valueOf(this.options.isDurableWrites())));
    }

    public Session getSession() {
        return this.session;
    }

    private Create getCreateTable(String safeTableName) {
        return (Create)SchemaBuilder.createTable((String)this.gwNamespace, (String)safeTableName).ifNotExists();
    }

    private void executeCreateTable(Create create, String safeTableName) {
        this.session.execute((Statement)create);
        this.state.tableExistsCache.put(safeTableName, true);
    }

    public Insert getInsert(String table) {
        return QueryBuilder.insertInto((String)this.gwNamespace, (String)CassandraOperations.getCassandraSafeName(table));
    }

    public Delete getDelete(String table) {
        return QueryBuilder.delete().from(this.gwNamespace, CassandraOperations.getCassandraSafeName(table));
    }

    public Select getSelect(String table, String ... columns) {
        return (columns.length == 0 ? QueryBuilder.select() : QueryBuilder.select((String[])columns)).from(this.gwNamespace, CassandraOperations.getCassandraSafeName(table));
    }

    public BaseDataStoreOptions getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchedWrite getBatchedWrite(String tableName) {
        PreparedStatement preparedWrite;
        String safeTableName = CassandraOperations.getCassandraSafeName(tableName);
        boolean isDataIndex = DataIndexUtils.isDataIndex((String)tableName);
        Map<String, PreparedStatement> map = this.state.preparedWritesPerTable;
        synchronized (map) {
            preparedWrite = this.state.preparedWritesPerTable.get(safeTableName);
            if (preparedWrite == null) {
                Insert insert = this.getInsert(safeTableName);
                CassandraRow.CassandraField[] fields = CassandraRow.CassandraField.values();
                if (isDataIndex) {
                    fields = (CassandraRow.CassandraField[])Arrays.stream(fields).filter(f -> f.isDataIndexColumn()).toArray(CassandraRow.CassandraField[]::new);
                }
                for (CassandraRow.CassandraField f2 : fields) {
                    insert.value(f2.getFieldName(), (Object)QueryBuilder.bindMarker((String)f2.getBindMarkerName()));
                }
                preparedWrite = this.session.prepare((RegularStatement)insert);
                this.state.preparedWritesPerTable.put(safeTableName, preparedWrite);
            }
        }
        return new BatchedWrite(this.session, preparedWrite, isDataIndex ? 1 : this.options.getBatchWriteSize(), isDataIndex, this.options.isVisibilityEnabled());
    }

    public RowWriter createDataIndexWriter(InternalDataAdapter<?> adapter) {
        return this.createWriter(DataIndexUtils.DATA_ID_INDEX, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchedRangeRead getBatchedRangeRead(String tableName, short[] adapterIds, Collection<SinglePartitionQueryRanges> ranges, boolean rowMerging, GeoWaveRowIteratorTransformer<?> rowTransformer, Predicate<GeoWaveRow> rowFilter) {
        PreparedStatement preparedRead;
        String safeTableName = CassandraOperations.getCassandraSafeName(tableName);
        Map<String, PreparedStatement> map = this.state.preparedRangeReadsPerTable;
        synchronized (map) {
            preparedRead = this.state.preparedRangeReadsPerTable.get(safeTableName);
            if (preparedRead == null) {
                Select select = this.getSelect(safeTableName, new String[0]);
                select.where(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getFieldName(), (Object)QueryBuilder.bindMarker((String)CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getBindMarkerName()))).and(QueryBuilder.in((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getFieldName(), (Object[])new Object[]{QueryBuilder.bindMarker((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getBindMarkerName())})).and(QueryBuilder.gte((String)CassandraRow.CassandraField.GW_SORT_KEY.getFieldName(), (Object)QueryBuilder.bindMarker((String)CassandraRow.CassandraField.GW_SORT_KEY.getLowerBoundBindMarkerName()))).and(QueryBuilder.lt((String)CassandraRow.CassandraField.GW_SORT_KEY.getFieldName(), (Object)QueryBuilder.bindMarker((String)CassandraRow.CassandraField.GW_SORT_KEY.getUpperBoundBindMarkerName())));
                preparedRead = this.session.prepare((RegularStatement)select);
                this.state.preparedRangeReadsPerTable.put(safeTableName, preparedRead);
            }
        }
        return new BatchedRangeRead(preparedRead, this, adapterIds, ranges, rowMerging, rowTransformer, rowFilter);
    }

    public CloseableIterator<CassandraRow> executeQuery(Statement ... statements) {
        Iterator results = Iterators.transform(Arrays.asList(statements).iterator(), s -> this.session.execute(s).iterator());
        Iterator rows = Iterators.concat((Iterator)results);
        return new CloseableIterator.Wrapper(Iterators.transform((Iterator)rows, r -> new CassandraRow((Row)r)));
    }

    public void deleteAll() throws Exception {
        this.state.tableExistsCache.clear();
        this.state.preparedRangeReadsPerTable.clear();
        this.state.preparedRowReadPerTable.clear();
        this.state.preparedWritesPerTable.clear();
        this.session.execute((Statement)SchemaBuilder.dropKeyspace((String)this.gwNamespace).ifExists());
    }

    public boolean deleteAll(String tableName, byte[] adapterId, String ... additionalAuthorizations) {
        this.session.execute((Statement)QueryBuilder.delete().from(this.gwNamespace, CassandraOperations.getCassandraSafeName(tableName)).where(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getFieldName(), (Object)ByteBuffer.wrap(adapterId))));
        return true;
    }

    public boolean deleteRows(String tableName, byte[][] dataIds, short internalAdapterId, String ... additionalAuthorizations) {
        this.session.execute((Statement)QueryBuilder.delete().from(this.gwNamespace, CassandraOperations.getCassandraSafeName(tableName)).where(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getFieldName(), (Object)internalAdapterId)).and(QueryBuilder.in((String)CassandraRow.CassandraField.GW_DATA_ID_KEY.getFieldName(), (Object[])new Object[]{Arrays.stream(dataIds).map(new ByteArrayToByteBuffer())})));
        return true;
    }

    public boolean deleteRow(String tableName, GeoWaveRow row, String ... additionalAuthorizations) {
        boolean exhausted = true;
        for (int i = 0; i < row.getFieldValues().length; ++i) {
            ResultSet rs = this.session.execute((Statement)QueryBuilder.delete().from(this.gwNamespace, CassandraOperations.getCassandraSafeName(tableName)).where(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getFieldName(), (Object)ByteBuffer.wrap(row.getPartitionKey()))).and(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_SORT_KEY.getFieldName(), (Object)ByteBuffer.wrap(row.getSortKey()))).and(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getFieldName(), (Object)row.getAdapterId())).and(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_DATA_ID_KEY.getFieldName(), (Object)ByteBuffer.wrap(row.getDataId()))).and(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_FIELD_VISIBILITY_KEY.getFieldName(), (Object)ByteBuffer.wrap(row.getFieldValues()[i].getVisibility()))));
            exhausted &= rs.isExhausted();
        }
        return !exhausted;
    }

    public boolean indexExists(String indexName) throws IOException {
        String tableName = CassandraOperations.getCassandraSafeName(indexName);
        Boolean tableExists = this.state.tableExistsCache.get(tableName);
        if (tableExists == null) {
            KeyspaceMetadata keyspace = this.session.getCluster().getMetadata().getKeyspace(this.gwNamespace);
            tableExists = keyspace != null ? Boolean.valueOf(keyspace.getTable(tableName) != null) : Boolean.valueOf(false);
            this.state.tableExistsCache.put(tableName, tableExists);
        }
        return tableExists;
    }

    public boolean deleteAll(String indexName, String typeName, Short adapterId, String ... additionalAuthorizations) {
        return false;
    }

    public boolean ensureAuthorizations(String clientUser, String ... authorizations) {
        return true;
    }

    public RowWriter createWriter(Index index, InternalDataAdapter<?> adapter) {
        this.createTable(index.getName());
        return new CassandraWriter(index.getName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(String indexName) {
        Object object = CREATE_TABLE_MUTEX;
        synchronized (object) {
            try {
                if (!this.indexExists(indexName)) {
                    String tableName = CassandraOperations.getCassandraSafeName(indexName);
                    Create create = this.getCreateTable(tableName);
                    CassandraRow.CassandraField[] fields = CassandraRow.CassandraField.values();
                    if (DataIndexUtils.isDataIndex((String)tableName)) {
                        fields = (CassandraRow.CassandraField[])Arrays.stream(fields).filter(f -> f.isDataIndexColumn()).toArray(CassandraRow.CassandraField[]::new);
                    }
                    for (CassandraRow.CassandraField f2 : fields) {
                        f2.addColumn(create);
                    }
                    this.executeCreateTable(create, tableName);
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to create table '" + indexName + "'", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataWriter createMetadataWriter(MetadataType metadataType) {
        String tableName = this.getMetadataTableName(metadataType);
        Object object = CREATE_TABLE_MUTEX;
        synchronized (object) {
            try {
                if (!this.indexExists(tableName)) {
                    Create create = this.getCreateTable(tableName);
                    create.addPartitionKey("I", DataType.blob());
                    if (MetadataType.STATS.equals((Object)metadataType) || MetadataType.INTERNAL_ADAPTER.equals((Object)metadataType)) {
                        create.addClusteringColumn("S", DataType.blob());
                        create.addClusteringColumn("T", DataType.timeuuid());
                        if (MetadataType.STATS.equals((Object)metadataType)) {
                            create.addColumn("A", DataType.blob());
                        }
                    }
                    create.addColumn("V", DataType.blob());
                    this.executeCreateTable(create, tableName);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Unable to check if table exists", (Throwable)e);
            }
        }
        return new CassandraMetadataWriter(this, tableName);
    }

    public MetadataReader createMetadataReader(MetadataType metadataType) {
        return new CassandraMetadataReader(this, metadataType);
    }

    public MetadataDeleter createMetadataDeleter(MetadataType metadataType) {
        return new CassandraMetadataDeleter(this, metadataType);
    }

    public <T> RowReader<T> createReader(ReaderParams<T> readerParams) {
        return new CassandraReader<T>(readerParams, this, this.options.isVisibilityEnabled());
    }

    public RowReader<GeoWaveRow> createReader(DataIndexReaderParams readerParams) {
        Iterator<Object> iterator;
        if (readerParams.getDataIds() == null) {
            if (readerParams.getStartInclusiveDataId() != null || readerParams.getEndInclusiveDataId() != null) {
                ArrayList intermediaries = new ArrayList();
                ByteArrayUtils.addAllIntermediaryByteArrays(intermediaries, (ByteArrayRange)new ByteArrayRange(readerParams.getStartInclusiveDataId(), readerParams.getEndInclusiveDataId()));
                byte[][] dataIds = (byte[][])intermediaries.toArray((T[])new byte[0][]);
                iterator = this.getRows(dataIds, readerParams.getAdapterId());
            } else {
                iterator = this.getRows(readerParams.getAdapterId());
            }
        } else {
            byte[][] dataIds = readerParams.getDataIds();
            iterator = this.getRows(dataIds, readerParams.getAdapterId());
        }
        if (this.options.isVisibilityEnabled()) {
            Stream stream = Streams.stream(iterator);
            HashSet authorizations = Sets.newHashSet((Object[])readerParams.getAdditionalAuthorizations());
            stream = stream.filter(new ClientVisibilityFilter((Set)authorizations));
            iterator = stream.iterator();
        }
        return new RowReaderWrapper((CloseableIterator)new CloseableIterator.Wrapper(iterator));
    }

    public Iterator<GeoWaveRow> getRows(short adapterId) {
        String tableName = DataIndexUtils.DATA_ID_INDEX.getName();
        String safeTableName = CassandraOperations.getCassandraSafeName(tableName);
        ResultSet results = this.getSession().execute("select * from " + this.gwNamespace + "." + safeTableName + " where " + CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getFieldName() + " = " + adapterId + " ALLOW FILTERING");
        return Streams.stream((Iterator)results.iterator()).map(r -> {
            byte[] d = r.getBytes(CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getFieldName()).array();
            byte[] v = r.getBytes(CassandraRow.CassandraField.GW_VALUE_KEY.getFieldName()).array();
            return DataIndexUtils.deserializeDataIndexRow((byte[])d, (short)adapterId, (byte[])v, (boolean)this.options.isVisibilityEnabled());
        }).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<GeoWaveRow> getRows(byte[][] dataIds, short adapterId) {
        PreparedStatement preparedRead;
        String tableName = DataIndexUtils.DATA_ID_INDEX.getName();
        String safeTableName = CassandraOperations.getCassandraSafeName(tableName);
        Map<String, PreparedStatement> map = this.state.preparedRangeReadsPerTable;
        synchronized (map) {
            preparedRead = this.state.preparedRangeReadsPerTable.get(safeTableName);
            if (preparedRead == null) {
                Select select = this.getSelect(safeTableName, new String[0]);
                select.where(QueryBuilder.in((String)CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getFieldName(), (Object[])new Object[]{QueryBuilder.bindMarker((String)CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getBindMarkerName())})).and(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getFieldName(), (Object)QueryBuilder.bindMarker((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getBindMarkerName())));
                preparedRead = this.session.prepare((RegularStatement)select);
                this.state.preparedRangeReadsPerTable.put(safeTableName, preparedRead);
            }
        }
        BoundStatement statement = new BoundStatement(preparedRead);
        statement.set(CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getBindMarkerName(), (Object)adapterId, (TypeCodec)TypeCodec.smallInt());
        statement.set(CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getBindMarkerName(), Arrays.stream(dataIds).map(d -> ByteBuffer.wrap(d)).collect(Collectors.toList()), TypeCodec.list((TypeCodec)TypeCodec.blob()));
        ResultSet results = this.getSession().execute((Statement)statement);
        HashMap resultsMap = new HashMap();
        results.forEach(r -> {
            byte[] d = r.getBytes(CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getFieldName()).array();
            byte[] v = r.getBytes(CassandraRow.CassandraField.GW_VALUE_KEY.getFieldName()).array();
            resultsMap.put(new ByteArray(d), DataIndexUtils.deserializeDataIndexRow((byte[])d, (short)adapterId, (byte[])v, (boolean)this.options.isVisibilityEnabled()));
        });
        return Arrays.stream(dataIds).map(d -> (GeoWaveRow)resultsMap.get(new ByteArray(d))).filter(r -> r != null).iterator();
    }

    public RowDeleter createRowDeleter(String indexName, PersistentAdapterStore adapterStore, InternalAdapterStore internalAdapterStore, String ... authorizations) {
        return new CassandraDeleter(this, indexName);
    }

    public RowReader<GeoWaveRow> createReader(RecordReaderParams recordReaderParams) {
        return new CassandraReader<GeoWaveRow>(recordReaderParams, this, this.options.isVisibilityEnabled());
    }

    public boolean metadataExists(MetadataType metadataType) throws IOException {
        return this.indexExists(this.getMetadataTableName(metadataType));
    }

    public String getMetadataTableName(MetadataType metadataType) {
        String tableName = metadataType.name() + "_" + "GEOWAVE_METADATA";
        return tableName;
    }

    public boolean createIndex(Index index) throws IOException {
        return this.createTable(index.getName());
    }

    public void delete(DataIndexReaderParams readerParams) {
        this.deleteRowsFromDataIndex(readerParams.getDataIds(), readerParams.getAdapterId());
    }

    public void deleteRowsFromDataIndex(byte[][] dataIds, short adapterId) {
        this.session.execute((Statement)QueryBuilder.delete().from(this.gwNamespace, CassandraOperations.getCassandraSafeName(DataIndexUtils.DATA_ID_INDEX.getName())).where(QueryBuilder.in((String)CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getFieldName(), (Iterable)Arrays.stream(dataIds).map(d -> ByteBuffer.wrap(d)).collect(Collectors.toList()))).and(QueryBuilder.eq((String)CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getFieldName(), (Object)adapterId)));
    }

    public static class StringToByteBuffer
    implements Function<String, ByteBuffer> {
        @Override
        public ByteBuffer apply(String input) {
            return ByteBuffer.wrap(StringUtils.stringToBinary((String)input));
        }
    }

    public static class ByteArrayIdToByteBuffer
    implements Function<ByteArray, ByteBuffer> {
        @Override
        public ByteBuffer apply(ByteArray input) {
            return ByteBuffer.wrap(input.getBytes());
        }
    }

    private static class ByteArrayToByteBuffer
    implements Function<byte[], ByteBuffer> {
        private ByteArrayToByteBuffer() {
        }

        @Override
        public ByteBuffer apply(byte[] input) {
            return ByteBuffer.wrap(input);
        }
    }
}

