/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.bouncycastle.util.Arrays;
import org.locationtech.geowave.core.index.ByteArrayRange;
import org.locationtech.geowave.core.index.SinglePartitionQueryRanges;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.CloseableIteratorWrapper;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveRowIteratorTransformer;
import org.locationtech.geowave.core.store.entities.GeoWaveRowMergingIterator;
import org.locationtech.geowave.core.store.operations.RangeReaderParams;
import org.locationtech.geowave.core.store.operations.ReaderParams;
import org.locationtech.geowave.core.store.operations.RowReader;
import org.locationtech.geowave.core.store.query.filter.ClientVisibilityFilter;
import org.locationtech.geowave.core.store.util.DataStoreUtils;
import org.locationtech.geowave.datastore.cassandra.CassandraRow;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraOperations;
import org.locationtech.geowave.mapreduce.splits.GeoWaveRowRange;
import org.locationtech.geowave.mapreduce.splits.RecordReaderParams;

public class CassandraReader<T>
implements RowReader<T> {
    private final ReaderParams<T> readerParams;
    private final RecordReaderParams recordReaderParams;
    private final CassandraOperations operations;
    private final GeoWaveRowIteratorTransformer<T> rowTransformer;
    private CloseableIterator<T> iterator;
    private final boolean visibilityEnabled;

    public CassandraReader(ReaderParams<T> readerParams, CassandraOperations operations, boolean visibilityEnabled) {
        this.readerParams = readerParams;
        this.recordReaderParams = null;
        this.operations = operations;
        this.rowTransformer = readerParams.getRowTransformer();
        this.visibilityEnabled = visibilityEnabled;
        this.initScanner();
    }

    public CassandraReader(RecordReaderParams recordReaderParams, CassandraOperations operations, boolean visibilityEnabled) {
        this.readerParams = null;
        this.recordReaderParams = recordReaderParams;
        this.operations = operations;
        this.visibilityEnabled = visibilityEnabled;
        this.rowTransformer = GeoWaveRowIteratorTransformer.NO_OP_TRANSFORMER;
        this.initRecordScanner();
    }

    private CloseableIterator<T> wrapResults(CloseableIterator<CassandraRow> results, RangeReaderParams<T> readerParams) {
        HashSet authorizations = Sets.newHashSet((Object[])readerParams.getAdditionalAuthorizations());
        GeoWaveRowMergingIterator iterator = Streams.stream(results).filter(new ClientVisibilityFilter((Set)authorizations)).iterator();
        return new CloseableIteratorWrapper(results, (Iterator)this.rowTransformer.apply((Object)(DataStoreUtils.isMergingIteratorRequired(readerParams, (boolean)this.visibilityEnabled) ? new GeoWaveRowMergingIterator((Iterator)iterator) : iterator)));
    }

    protected void initScanner() {
        Collection ranges = this.readerParams.getQueryRanges().getPartitionQueryRanges();
        if (ranges != null && !ranges.isEmpty()) {
            this.iterator = this.operations.getBatchedRangeRead(this.readerParams.getIndex().getName(), this.readerParams.getAdapterIds(), ranges, DataStoreUtils.isMergingIteratorRequired(this.readerParams, (boolean)this.visibilityEnabled), this.rowTransformer, (Predicate<GeoWaveRow>)new ClientVisibilityFilter((Set)Sets.newHashSet((Object[])this.readerParams.getAdditionalAuthorizations()))).results();
        } else {
            Select select = this.operations.getSelect(this.readerParams.getIndex().getName(), new String[0]);
            CloseableIteratorWrapper results = this.operations.executeQuery(new Statement[]{select});
            if (this.readerParams.getAdapterIds() != null && this.readerParams.getAdapterIds().length > 0) {
                results = new CloseableIteratorWrapper(results, (Iterator)Iterators.filter(results, input -> Arrays.contains((short[])this.readerParams.getAdapterIds(), (short)input.getAdapterId())));
            }
            this.iterator = this.wrapResults((CloseableIterator<CassandraRow>)results, (RangeReaderParams<T>)this.readerParams);
        }
    }

    protected void initRecordScanner() {
        short[] adapterIds = this.recordReaderParams.getAdapterIds() != null ? this.recordReaderParams.getAdapterIds() : new short[]{};
        GeoWaveRowRange range = this.recordReaderParams.getRowRange();
        byte[] startKey = range.isInfiniteStartSortKey() ? null : range.getStartSortKey();
        byte[] stopKey = range.isInfiniteStopSortKey() ? null : range.getEndSortKey();
        SinglePartitionQueryRanges partitionRange = new SinglePartitionQueryRanges(range.getPartitionKey(), Collections.singleton(new ByteArrayRange(startKey, stopKey)));
        HashSet authorizations = Sets.newHashSet((Object[])this.recordReaderParams.getAdditionalAuthorizations());
        this.iterator = this.operations.getBatchedRangeRead(this.recordReaderParams.getIndex().getName(), adapterIds, Collections.singleton(partitionRange), DataStoreUtils.isMergingIteratorRequired((RangeReaderParams)this.recordReaderParams, (boolean)this.visibilityEnabled), this.rowTransformer, (Predicate<GeoWaveRow>)new ClientVisibilityFilter((Set)authorizations)).results();
    }

    public void close() {
        this.iterator.close();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public T next() {
        return (T)this.iterator.next();
    }
}

