/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.operations.RowWriter;
import org.locationtech.geowave.datastore.cassandra.operations.BatchedWrite;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraWriter
implements RowWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraWriter.class);
    private final Object MUTEX = new Object();
    private BatchedWrite batchedWrite = null;
    private final CassandraOperations operations;
    private final String tableName;

    public CassandraWriter(String tableName, CassandraOperations operations) {
        this.tableName = tableName;
        this.operations = operations;
    }

    public void close() throws Exception {
        this.flush();
    }

    public void write(GeoWaveRow[] rows) {
        for (GeoWaveRow row : rows) {
            this.write(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(GeoWaveRow row) {
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.batchedWrite == null) {
                this.batchedWrite = this.operations.getBatchedWrite(this.tableName);
            }
            this.batchedWrite.insert(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.batchedWrite != null) {
                try {
                    this.batchedWrite.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to close batched write", (Throwable)e);
                }
            }
        }
    }
}

