/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.operations;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import java.nio.ByteBuffer;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.datastore.cassandra.CassandraRow;
import org.locationtech.geowave.datastore.cassandra.operations.CassandraOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowRead {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowRead.class);
    private final CassandraOperations operations;
    private final PreparedStatement preparedRead;
    private final short internalAdapterId;
    private final byte[] partitionKey;
    private final byte[] sortKey;

    protected RowRead(PreparedStatement preparedRead, CassandraOperations operations, byte[] partitionKey, byte[] sortKey, Short internalAdapterId) {
        this.preparedRead = preparedRead;
        this.operations = operations;
        this.partitionKey = partitionKey;
        this.sortKey = sortKey;
        this.internalAdapterId = internalAdapterId;
    }

    public CassandraRow result() {
        if (this.partitionKey != null && this.sortKey != null) {
            BoundStatement boundRead = new BoundStatement(this.preparedRead);
            boundRead.set(CassandraRow.CassandraField.GW_SORT_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(this.sortKey), ByteBuffer.class);
            boundRead.set(CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getBindMarkerName(), (Object)this.internalAdapterId, (TypeCodec)TypeCodec.smallInt());
            boundRead.set(CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(this.partitionKey), ByteBuffer.class);
            try (CloseableIterator<CassandraRow> it = this.operations.executeQuery(new Statement[]{boundRead});){
                if (it.hasNext()) {
                    CassandraRow cassandraRow = (CassandraRow)((Object)it.next());
                    return cassandraRow;
                }
            }
        }
        return null;
    }
}

