/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.util;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import java.nio.ByteBuffer;
import org.locationtech.geowave.core.store.base.dataidx.DataIndexUtils;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveValue;
import org.locationtech.geowave.datastore.cassandra.CassandraRow;

public class CassandraUtils {
    public static final byte[] EMPTY_PARTITION_KEY = new byte[]{0};

    public static BoundStatement[] bindInsertion(PreparedStatement insertionStatement, GeoWaveRow row, boolean isDataIndex, boolean visibilityEnabled) {
        return isDataIndex ? CassandraUtils.bindDataIndexInsertion(insertionStatement, row, visibilityEnabled) : CassandraUtils.bindInsertion(insertionStatement, row);
    }

    public static BoundStatement[] bindDataIndexInsertion(PreparedStatement insertionStatement, GeoWaveRow row, boolean visibilityEnabled) {
        byte[] partitionKey = row.getDataId();
        if (partitionKey == null || partitionKey.length == 0) {
            partitionKey = EMPTY_PARTITION_KEY;
        }
        BoundStatement[] retVal = new BoundStatement[row.getFieldValues().length];
        int i = 0;
        for (GeoWaveValue value : row.getFieldValues()) {
            ByteBuffer nanoBuffer = ByteBuffer.allocate(8);
            nanoBuffer.putLong(0, Long.MAX_VALUE - System.nanoTime());
            retVal[i] = new BoundStatement(insertionStatement);
            retVal[i].set(CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(partitionKey), ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getBindMarkerName(), (Object)row.getAdapterId(), Short.class);
            retVal[i].set(CassandraRow.CassandraField.GW_VALUE_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(DataIndexUtils.serializeDataIndexValue((GeoWaveValue)value, (boolean)visibilityEnabled)), ByteBuffer.class);
            ++i;
        }
        return retVal;
    }

    public static BoundStatement[] bindInsertion(PreparedStatement insertionStatement, GeoWaveRow row) {
        byte[] partitionKey = row.getPartitionKey();
        if (partitionKey == null || partitionKey.length == 0) {
            partitionKey = EMPTY_PARTITION_KEY;
        }
        BoundStatement[] retVal = new BoundStatement[row.getFieldValues().length];
        int i = 0;
        for (GeoWaveValue value : row.getFieldValues()) {
            ByteBuffer nanoBuffer = ByteBuffer.allocate(8);
            nanoBuffer.putLong(0, Long.MAX_VALUE - System.nanoTime());
            retVal[i] = new BoundStatement(insertionStatement);
            retVal[i].set(CassandraRow.CassandraField.GW_PARTITION_ID_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(partitionKey), ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_SORT_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(row.getSortKey()), ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_DATA_ID_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(row.getDataId()), ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_FIELD_VISIBILITY_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(value.getVisibility()), ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_NANO_TIME_KEY.getBindMarkerName(), (Object)nanoBuffer, ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_FIELD_MASK_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(value.getFieldMask()), ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_ADAPTER_ID_KEY.getBindMarkerName(), (Object)row.getAdapterId(), Short.class);
            retVal[i].set(CassandraRow.CassandraField.GW_VALUE_KEY.getBindMarkerName(), (Object)ByteBuffer.wrap(value.getValue()), ByteBuffer.class);
            retVal[i].set(CassandraRow.CassandraField.GW_NUM_DUPLICATES_KEY.getBindMarkerName(), (Object)((byte)row.getNumberOfDuplicates()), Byte.TYPE);
            ++i;
        }
        return retVal;
    }
}

