/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.util;

import com.datastax.driver.core.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class KeyspaceStatePool {
    private static KeyspaceStatePool singletonInstance;
    private final Map<Pair<String, String>, KeyspaceState> keyspaceStateCache = new HashMap<Pair<String, String>, KeyspaceState>();

    public static synchronized KeyspaceStatePool getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new KeyspaceStatePool();
        }
        return singletonInstance;
    }

    protected KeyspaceStatePool() {
    }

    public synchronized KeyspaceState getCachedState(String contactPoints, String keyspace) {
        ImmutablePair key = ImmutablePair.of((Object)contactPoints, (Object)keyspace);
        KeyspaceState state = this.keyspaceStateCache.get(key);
        if (state == null) {
            state = new KeyspaceState();
            this.keyspaceStateCache.put((Pair<String, String>)key, state);
        }
        return state;
    }

    public static class KeyspaceState {
        public final Map<String, PreparedStatement> preparedRangeReadsPerTable = new HashMap<String, PreparedStatement>();
        public final Map<String, PreparedStatement> preparedRowReadPerTable = new HashMap<String, PreparedStatement>();
        public final Map<String, PreparedStatement> preparedWritesPerTable = new HashMap<String, PreparedStatement>();
        public final Map<String, Boolean> tableExistsCache = new HashMap<String, Boolean>();
    }
}

