/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.cassandra.util;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionPool.class);
    private static SessionPool singletonInstance;
    private final LoadingCache<String, Session> sessionCache = Caffeine.newBuilder().build(contactPoints -> Cluster.builder().addContactPoints(contactPoints.split(",")).build().connect());

    public static synchronized SessionPool getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new SessionPool();
        }
        return singletonInstance;
    }

    protected SessionPool() {
    }

    public synchronized Session getSession(String contactPoints) {
        if (contactPoints == null) {
            LOGGER.error("contact points must be set for cassandra");
            return null;
        }
        return (Session)this.sessionCache.get((Object)contactPoints);
    }
}

