/*
 * Decompiled with CFR 0.152.
 */
package astraea.spark.rasterframes.extensions;

import astraea.spark.rasterframes.StandardColumns$;
import astraea.spark.rasterframes.extensions.DataFrameMethods;
import astraea.spark.rasterframes.extensions.Implicits$;
import geotrellis.raster.Tile;
import geotrellis.spark.SpaceTimeKey;
import geotrellis.spark.SpaceTimeKey$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TemporalKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.io.package$;
import geotrellis.util.Component;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.gt.types.TileUDT$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Try$;
import spray.json.JsonFormat;

public abstract class DataFrameMethods$class {
    private static Function1 selector(DataFrameMethods $this, Column column) {
        return new Serializable($this, column){
            public static final long serialVersionUID = 0L;
            private final Column column$1;

            public final boolean apply(Attribute attr) {
                String string = attr.name();
                String string2 = astraea.spark.rasterframes.util.package$.MODULE$.NamedColumn(this.column$1).columnName();
                return !(string == null ? string2 != null : !string.equals(string2)) || attr.semanticEquals(this.column$1.expr());
            }
            {
                this.column$1 = column$1;
            }
        };
    }

    public static Dataset mapColumnAttribute(DataFrameMethods $this, Column column, Function1 op) {
        Seq analyzed = ((Dataset)$this.self()).queryExecution().analyzed().output();
        Function1 selects = DataFrameMethods$class.selector($this, column);
        Seq attrs = (Seq)analyzed.map((Function1)new Serializable($this, selects, op){
            public static final long serialVersionUID = 0L;
            private final Function1 selects$1;
            private final Function1 op$1;

            public final Attribute apply(Attribute attr) {
                return BoxesRunTime.unboxToBoolean((Object)this.selects$1.apply((Object)attr)) ? (Attribute)this.op$1.apply((Object)attr) : attr;
            }
            {
                void var3_3;
                this.selects$1 = selects$1;
                this.op$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return ((Dataset)$this.self()).select((Seq)attrs.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Column apply(Attribute a) {
                return new Column((Expression)a);
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public static Dataset addColumnMetadata(DataFrameMethods $this, Column column, Function1 op) {
        return $this.mapColumnAttribute(column, (Function1<Attribute, Attribute>)new Serializable($this, op){
            public static final long serialVersionUID = 0L;
            private final Function1 op$2;

            public final Attribute apply(Attribute attr) {
                MetadataBuilder md = new MetadataBuilder().withMetadata(attr.metadata());
                return attr.withMetadata(((MetadataBuilder)this.op$2.apply((Object)md)).build());
            }
            {
                this.op$2 = op$2;
            }
        });
    }

    public static Option fetchMetadataValue(DataFrameMethods $this, Column column, Function1 reader) {
        Seq analyzed = ((Dataset)$this.self()).queryExecution().analyzed().output();
        return analyzed.find(DataFrameMethods$class.selector($this, column)).map(reader);
    }

    public static Dataset setSpatialColumnRole(DataFrameMethods $this, Column column, TileLayerMetadata md, Component evidence$1, JsonFormat evidence$2) {
        return $this.addColumnMetadata(column, (Function1<MetadataBuilder, MetadataBuilder>)new Serializable($this, md, evidence$1, evidence$2){
            public static final long serialVersionUID = 0L;
            private final TileLayerMetadata md$1;
            private final Component evidence$1$1;
            private final JsonFormat evidence$2$1;

            public final MetadataBuilder apply(MetadataBuilder x$1) {
                return Implicits$.MODULE$.WithMetadataBuilderMethods(Implicits$.MODULE$.WithMetadataBuilderMethods(x$1).attachContext(Implicits$.MODULE$.WithMetadataMethods(this.md$1, package$.MODULE$.tileLayerMetadataFormat(this.evidence$1$1, this.evidence$2$1)).asColumnMetadata())).tagSpatialKey();
            }
            {
                void var4_4;
                void var3_3;
                this.md$1 = md$1;
                this.evidence$1$1 = var3_3;
                this.evidence$2$1 = var4_4;
            }
        });
    }

    public static Dataset setTemporalColumnRole(DataFrameMethods $this, Column column) {
        return $this.addColumnMetadata(column, (Function1<MetadataBuilder, MetadataBuilder>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final MetadataBuilder apply(MetadataBuilder x$2) {
                return Implicits$.MODULE$.WithMetadataBuilderMethods(x$2).tagTemporalKey();
            }
        });
    }

    public static Option getColumnRole(DataFrameMethods $this, Column column) {
        return $this.fetchMetadataValue(column, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameMethods $outer;

            public final String apply(Attribute x$3) {
                return x$3.metadata().getString(this.$outer.SPATIAL_ROLE_KEY());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Seq tileColumns(DataFrameMethods $this) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((Dataset)$this.self()).schema().fields()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$4) {
                return x$4.dataType().typeName().equalsIgnoreCase(TileUDT$.MODULE$.typeName());
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final TypedColumn<Object, Tile> apply(StructField f) {
                return functions$.MODULE$.col(f.name()).as(StandardColumns$.MODULE$.singlebandTileEncoder());
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public static Option spatialKeyColumn(DataFrameMethods $this) {
        Option<StructField> key = $this.findSpatialKeyField();
        return key.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$5) {
                return x$5.name();
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final TypedColumn<Object, SpatialKey> apply(String x$6) {
                return functions$.MODULE$.col(x$6).as(StandardColumns$.MODULE$.spatialKeyEncoder());
            }
        });
    }

    public static Option temporalKeyColumn(DataFrameMethods $this) {
        Option<StructField> key = $this.findTemporalKeyField();
        return key.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$7) {
                return x$7.name();
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final TypedColumn<Object, TemporalKey> apply(String x$8) {
                return functions$.MODULE$.col(x$8).as(StandardColumns$.MODULE$.temporalKeyEncoder());
            }
        });
    }

    public static Option findRoleField(DataFrameMethods $this, String role) {
        return Predef$.MODULE$.refArrayOps((Object[])((Dataset)$this.self()).schema().fields()).find((Function1)new Serializable($this, role){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameMethods $outer;
            private final String role$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(StructField f) {
                if (!f.metadata().contains(this.$outer.SPATIAL_ROLE_KEY())) return false;
                String string = f.metadata().getString(this.$outer.SPATIAL_ROLE_KEY());
                String string2 = this.role$1;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.role$1 = role$1;
            }
        });
    }

    public static Option findSpatialKeyField(DataFrameMethods $this) {
        return $this.findRoleField(astraea.spark.rasterframes.util.package$.MODULE$.NamedColumn((Column)StandardColumns$.MODULE$.SPATIAL_KEY_COLUMN()).columnName());
    }

    public static Option findTemporalKeyField(DataFrameMethods $this) {
        return $this.findRoleField(astraea.spark.rasterframes.util.package$.MODULE$.NamedColumn((Column)StandardColumns$.MODULE$.TEMPORAL_KEY_COLUMN()).columnName());
    }

    public static Dataset withPrefixedColumnNames(DataFrameMethods $this, String prefix) {
        return (Dataset)Predef$.MODULE$.refArrayOps((Object[])((Dataset)$this.self()).columns()).foldLeft($this.self(), (Function2)new Serializable($this, prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final DF apply(DF df, String c) {
                return (DF)df.withColumnRenamed(c, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1, c})));
            }
            {
                this.prefix$1 = prefix$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Dataset asRF(DataFrameMethods $this) throws IllegalArgumentException {
        void var1_1;
        Dataset<Row> potentialRF = astraea.spark.rasterframes.util.package$.MODULE$.certifyRasterframe((Dataset<Row>)((Dataset)$this.self()));
        Predef$.MODULE$.require(Implicits$.MODULE$.WithDataFrameMethods(potentialRF).findSpatialKeyField().nonEmpty(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A RasterFrame requires a column identified as a spatial key";
            }
        });
        Predef$.MODULE$.require(Implicits$.MODULE$.WithDataFrameMethods(potentialRF).tileColumns().nonEmpty(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A RasterFrame requires at least one tile column";
            }
        });
        Predef$.MODULE$.require(Try$.MODULE$.apply((Function0)new Serializable($this, potentialRF){
            public static final long serialVersionUID = 0L;
            private final Dataset potentialRF$1;

            public final Either<TileLayerMetadata<SpatialKey>, TileLayerMetadata<SpaceTimeKey>> apply() {
                return Implicits$.MODULE$.WithRasterFrameMethods((Dataset<Row>)this.potentialRF$1).tileLayerMetadata();
            }
            {
                this.potentialRF$1 = potentialRF$1;
            }
        }).isSuccess(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A RasterFrame requires embedded TileLayerMetadata";
            }
        });
        return var1_1;
    }

    public static Dataset asRF(DataFrameMethods $this, Column spatialKey, TileLayerMetadata tlm) throws IllegalArgumentException {
        return Implicits$.MODULE$.WithDataFrameMethods($this.setSpatialColumnRole(spatialKey, tlm, geotrellis.util.package$.MODULE$.identityComponent(), package$.MODULE$.SpatialKeyFormat())).asRF();
    }

    public static Dataset asRF(DataFrameMethods $this, Column spatialKey, Column temporalKey, TileLayerMetadata tlm) throws IllegalArgumentException {
        return Implicits$.MODULE$.WithDataFrameMethods(Implicits$.MODULE$.WithDataFrameMethods($this.setSpatialColumnRole(spatialKey, tlm, SpaceTimeKey$.MODULE$.spatialComponent(), package$.MODULE$.SpaceTimeKeyFormat())).setTemporalColumnRole(temporalKey)).asRF();
    }

    public static Option asRFSafely(DataFrameMethods $this) {
        return Try$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameMethods $outer;

            public final Dataset<Row> apply() {
                return this.$outer.asRF();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).toOption();
    }

    public static boolean isRF(DataFrameMethods $this) {
        return Try$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameMethods $outer;

            public final Dataset<Row> apply() {
                return this.$outer.asRF();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).isSuccess();
    }

    public static Dataset certify(DataFrameMethods $this) {
        return astraea.spark.rasterframes.util.package$.MODULE$.certifyRasterframe((Dataset<Row>)((Dataset)$this.self()));
    }

    public static void $init$(DataFrameMethods $this) {
    }
}

