/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service;

import com.typesafe.config.Config;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.logdoc.fairhttp.service.api.helpers.EagerSingleton;
import org.logdoc.fairhttp.service.api.helpers.Preloaded;
import org.logdoc.fairhttp.service.api.helpers.Singleton;
import org.logdoc.fairhttp.service.http.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DI {
    private static final Logger logger = LoggerFactory.getLogger(DI.class);
    private static final Set<Class<? extends EagerSingleton>> eagers = new HashSet<Class<? extends EagerSingleton>>(8);
    private static final Map<Class<?>, Class<?>> bindMap = new HashMap(64);
    private static final Map<Integer, Supplier<?>> knownConstructors = new HashMap();
    private static final Map<Integer, Object> singleMap = new HashMap<Integer, Object>();
    private static Config config;

    static void init(Config config0) {
        config = config0;
        logger.info("Initializing");
        DI.bindProvider(Config.class, () -> config);
    }

    static void preload(Class<Preloaded> clas) {
        try {
            logger.info("Preloading '" + clas.getName() + "'");
            Preloaded p = clas.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            p.configure(config);
            logger.info("Successfully loaded '" + clas.getName() + "'");
        }
        catch (Exception e) {
            logger.error("Cant load '" + clas.getName() + "' :: " + e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initEagers() {
        if (eagers.isEmpty()) {
            return;
        }
        List init = Collections.emptyList();
        eagers.forEach(c -> {
            try {
                DI.gainInternal(c, init);
            }
            catch (Exception e) {
                logger.warn("Cant eager init singleton '" + c.getName() + "' :: " + e.getMessage(), (Throwable)e);
            }
        });
        eagers.clear();
    }

    public static synchronized <A> void bindProvider(Class<A> type, Supplier<? extends A> provider) {
        if (type == null) {
            throw new NullPointerException("Type is null");
        }
        if (provider == null) {
            throw new NullPointerException("Provider is null");
        }
        knownConstructors.put(type.hashCode(), provider);
    }

    public static synchronized <A, B extends A> void bind(Class<A> type, Class<B> implementation) {
        if (type == null) {
            throw new NullPointerException("Type is null");
        }
        if (implementation == null) {
            throw new NullPointerException("Implementation is null");
        }
        if (EagerSingleton.class.isAssignableFrom(implementation)) {
            eagers.add(implementation);
        }
        if (!type.equals(implementation)) {
            bindMap.put(type, implementation);
        }
        logger.debug("Bound type '" + type.getName() + "' to implementation '" + implementation.getName() + "'");
    }

    public static <A> A gain(Class<A> clas) {
        return DI.gainInternal(clas, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <A> A gainInternal(Class<A> clas, Collection<Class<?>> ancestors) {
        boolean missed;
        if (clas == null) {
            return null;
        }
        Class<?> c = bindMap.get(clas);
        if (c != null) {
            if (ancestors.contains(c)) {
                return null;
            }
            ArrayList ancestorz = new ArrayList(ancestors);
            ancestorz.add(clas);
            return (A)DI.gainInternal(c, ancestorz);
        }
        boolean singleton = Singleton.class.isAssignableFrom(clas);
        int hash = clas.hashCode();
        Object value = null;
        if (singleton) {
            value = singleMap.get(hash);
        }
        boolean bl = missed = value == null;
        if (missed) {
            value = DI.build(clas, hash, ancestors);
        }
        if (value == null) {
            return null;
        }
        if (singleton && missed) {
            Map<Integer, Object> map = singleMap;
            synchronized (map) {
                singleMap.put(hash, value);
            }
        }
        return (A)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <A> A build(Class<A> clas, int hash, Collection<Class<?>> ancestors) {
        Constructor<?>[] ctrs;
        Supplier<Object> constructor = knownConstructors.get(hash);
        if (constructor != null) {
            return (A)constructor.get();
        }
        for (Constructor<?> c : ctrs = clas.getDeclaredConstructors()) {
            if (c.isSynthetic() || c.getParameterCount() != 0 || !Modifier.isPublic(c.getModifiers())) continue;
            constructor = () -> {
                try {
                    return c.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    logger.error("!!! Cant build object of type '" + clas.getName() + "' :: " + e.getMessage(), (Throwable)e);
                    return null;
                }
            };
            break;
        }
        if (constructor == null) {
            ArrayList arrayList = new ArrayList(ancestors);
            arrayList.add(clas);
            block4: for (Constructor<?> c : ctrs) {
                if (c.isSynthetic() || !Modifier.isPublic(c.getModifiers())) continue;
                Class<?>[] args = c.getParameterTypes();
                ArrayList<Object> argz = new ArrayList<Object>(args.length);
                for (Class<?> arg : args) {
                    if (arg == null || arg.isPrimitive() || arg.isArray() || ancestors.contains(arg) || Map.class.isAssignableFrom(arg) || Collection.class.isAssignableFrom(arg) || arg.equals(clas) || Request.class.isAssignableFrom(arg)) continue block4;
                    if (arg.equals(Config.class)) {
                        argz.add(config);
                        continue;
                    }
                    Object o = DI.gainInternal(arg, arrayList);
                    if (o == null) continue block4;
                    argz.add(o);
                }
                if (argz.size() != c.getParameterCount()) {
                    logger.warn("Cant build constructors args: " + clas.getName() + " :: " + c);
                    continue;
                }
                ArrayList<Object> finalArgz = argz;
                constructor = () -> {
                    try {
                        return c.newInstance(finalArgz.toArray());
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        logger.error("!!! Cant build object of type '" + clas.getName() + "' :: " + e.getMessage(), (Throwable)e);
                        return null;
                    }
                };
                break;
            }
        }
        if (constructor == null) {
            logger.error("!!! Cant build object of type '" + clas.getName() + "' :: no valid constructor found.");
            return null;
        }
        Map<Integer, Supplier<?>> map = knownConstructors;
        synchronized (map) {
            knownConstructors.put(hash, constructor);
        }
        return (A)constructor.get();
    }
}

