/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.logdoc.fairhttp.service.DI;
import org.logdoc.fairhttp.service.api.helpers.MimeType;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.Server;
import org.logdoc.fairhttp.service.tools.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartFairServer {
    private static final Logger logger = LoggerFactory.getLogger(StartFairServer.class);

    public static void main(String[] args) {
        new StartFairServer().start();
    }

    private void start() {
        Config c = ConfigFactory.defaultApplication().withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
        DI.init(c);
        ArrayList<String> endpoints = new ArrayList<String>(16);
        try (InputStream is = StartFairServer.class.getClassLoader().getResourceAsStream("routes");
             ByteArrayOutputStream os = new ByteArrayOutputStream(65536);){
            if (is != null) {
                int read;
                byte[] buf = new byte[655360];
                while ((read = is.read(buf)) != -1) {
                    os.write(buf, 0, read);
                }
                os.flush();
                endpoints.addAll(Arrays.stream(os.toString(StandardCharsets.UTF_8).split("\\n")).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            logger.atDebug().log("Cant load routes config: " + e.getMessage(), (Object)e);
        }
        Server s = new Server(c);
        DI.bindProvider(Server.class, () -> s);
        s.setupConfigEndpoints(endpoints);
        Logger errorLogger = LoggerFactory.getLogger(ErrorHandler.class);
        s.setupErrorHandler(t -> {
            errorLogger.error(t.getMessage(), t);
            Response response = Response.ServerError();
            if (t.getMessage() != null) {
                response.setPayload(t.getMessage().getBytes(StandardCharsets.UTF_8), MimeType.TEXTPLAIN);
            }
            return response;
        });
        if (c.hasPath("fair.error_handler")) {
            try {
                ErrorHandler handler = (ErrorHandler)Class.forName(c.getString("fair.error_handler")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                s.setupErrorHandler(handler::handle);
            }
            catch (Exception e) {
                logger.warn("Cant setup custom error handler: " + e.getMessage());
            }
        }
        s.start();
        if (c.hasPath("fair.preload.load")) {
            c.getStringList("fair.preload.load").forEach(lc -> {
                try {
                    DI.preload(Class.forName(lc));
                }
                catch (Exception e) {
                    logger.error("Cant preload '" + lc + "' :: " + e.getMessage(), (Throwable)e);
                }
            });
        }
        DI.initEagers();
    }
}

