/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MimeType {
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";
    public static MimeType FORM = MimeType.of("application/x-www-form-urlencoded");
    public static MimeType JSON = MimeType.of("application/json");
    public static MimeType TEXTPLAIN = MimeType.of("text/plain");
    public static MimeType TEXTHTML = MimeType.of("text/html");
    public static MimeType BINARY = MimeType.of("application/octet-stream");
    public static MimeType XML = MimeType.of("application/xml");
    public static MimeType MULTIPART = MimeType.of("multipart/form-data");
    private String primaryType;
    private String subType;
    private ParamsList parameters;

    public MimeType() {
        this.primaryType = "application";
        this.subType = "*";
        this.parameters = new ParamsList();
    }

    public MimeType(String rawdata) throws Exception {
        this.parse(rawdata);
    }

    public MimeType(String primary, String sub) throws Exception {
        if (!this.isValidToken(primary)) {
            throw new Exception("Primary type is invalid.");
        }
        this.primaryType = primary.toLowerCase();
        if (!this.isValidToken(sub)) {
            throw new Exception("Sub type is invalid.");
        }
        this.subType = sub.toLowerCase();
        this.parameters = new ParamsList();
    }

    private static MimeType of(String knownSpec) {
        MimeType mt = new MimeType();
        mt.primaryType = knownSpec.substring(0, knownSpec.indexOf(47));
        mt.subType = knownSpec.substring(knownSpec.indexOf(47) + 1);
        mt.setParameter("charset", "UTF-8");
        return mt;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    public static MimeType guessMime(int[] head16bytes) {
        if (head16bytes[0] == 60 && head16bytes[1] == 115 && head16bytes[2] == 118 && head16bytes[3] == 103 && head16bytes[4] == 32) {
            return MimeType.of("image/svg+xml");
        }
        if (head16bytes[0] == 71 && head16bytes[1] == 73 && head16bytes[2] == 70 && head16bytes[3] == 56) {
            return MimeType.of("image/gif");
        }
        if (head16bytes[0] == 35 && head16bytes[1] == 100 && head16bytes[2] == 101 && head16bytes[3] == 102) {
            return MimeType.of("image/x-bitmap");
        }
        if (head16bytes[0] == 202 && head16bytes[1] == 254 && head16bytes[2] == 186 && head16bytes[3] == 190) {
            return MimeType.of("application/java-vm");
        }
        if (head16bytes[0] == 172 && head16bytes[1] == 237) {
            return MimeType.of("application/x-java-serialized-object");
        }
        if (head16bytes[0] == 46 && head16bytes[1] == 115 && head16bytes[2] == 110 && head16bytes[3] == 100) {
            return MimeType.of("audio/basic");
        }
        if (head16bytes[0] == 100 && head16bytes[1] == 110 && head16bytes[2] == 115 && head16bytes[3] == 46) {
            return MimeType.of("audio/basic");
        }
        if (head16bytes[0] == 82 && head16bytes[1] == 73 && head16bytes[2] == 70 && head16bytes[3] == 70) {
            return MimeType.of("audio/x-wav");
        }
        if (head16bytes[0] == 60) {
            if (head16bytes[1] == 33 || head16bytes[1] == 104 && (head16bytes[2] == 116 && head16bytes[3] == 109 && head16bytes[4] == 108 || head16bytes[2] == 101 && head16bytes[3] == 97 && head16bytes[4] == 100) || head16bytes[1] == 98 && head16bytes[2] == 111 && head16bytes[3] == 100 && head16bytes[4] == 121 || head16bytes[1] == 72 && (head16bytes[2] == 84 && head16bytes[3] == 77 && head16bytes[4] == 76 || head16bytes[2] == 69 && head16bytes[3] == 65 && head16bytes[4] == 68) || head16bytes[1] == 66 && head16bytes[2] == 79 && head16bytes[3] == 68 && head16bytes[4] == 89) {
                return MimeType.of("text/html");
            }
            if (head16bytes[1] == 63 && head16bytes[2] == 120 && head16bytes[3] == 109 && head16bytes[4] == 108 && head16bytes[5] == 32) {
                return MimeType.of("application/xml");
            }
        }
        if (head16bytes[0] == 239 && head16bytes[1] == 187 && head16bytes[2] == 191 && head16bytes[3] == 60 && head16bytes[4] == 63 && head16bytes[5] == 120) {
            return MimeType.of("application/xml");
        }
        if (head16bytes[0] == 33 && head16bytes[1] == 32 && head16bytes[2] == 88 && head16bytes[3] == 80 && head16bytes[4] == 77 && head16bytes[5] == 50) {
            return MimeType.of("image/x-pixmap");
        }
        if (head16bytes[0] == 254 && head16bytes[1] == 255 && head16bytes[2] == 0 && head16bytes[3] == 60 && head16bytes[4] == 0 && head16bytes[5] == 63 && head16bytes[6] == 0 && head16bytes[7] == 120) {
            return MimeType.of("application/xml");
        }
        if (head16bytes[0] == 255 && head16bytes[1] == 254 && head16bytes[2] == 60 && head16bytes[3] == 0 && head16bytes[4] == 63 && head16bytes[5] == 0 && head16bytes[6] == 120 && head16bytes[7] == 0) {
            return MimeType.of("application/xml");
        }
        if (head16bytes[0] == 137 && head16bytes[1] == 80 && head16bytes[2] == 78 && head16bytes[3] == 71 && head16bytes[4] == 13 && head16bytes[5] == 10 && head16bytes[6] == 26 && head16bytes[7] == 10) {
            return MimeType.of("image/png");
        }
        if (head16bytes[0] == 255 && head16bytes[1] == 216 && head16bytes[2] == 255) {
            if (head16bytes[3] == 224 || head16bytes[3] == 238) {
                return MimeType.of("image/jpeg");
            }
            if (head16bytes[3] == 225 && head16bytes[6] == 69 && head16bytes[7] == 120 && head16bytes[8] == 105 && head16bytes[9] == 102 && head16bytes[10] == 0) {
                return MimeType.of("image/jpeg");
            }
        }
        if (head16bytes[0] == 0 && head16bytes[1] == 0 && head16bytes[2] == 254 && head16bytes[3] == 255 && head16bytes[4] == 0 && head16bytes[5] == 0 && head16bytes[6] == 0 && head16bytes[7] == 60 && head16bytes[8] == 0 && head16bytes[9] == 0 && head16bytes[10] == 0 && head16bytes[11] == 63 && head16bytes[12] == 0 && head16bytes[13] == 0 && head16bytes[14] == 0 && head16bytes[15] == 120) {
            return MimeType.of("application/xml");
        }
        if (head16bytes[0] == 255 && head16bytes[1] == 254 && head16bytes[2] == 0 && head16bytes[3] == 0 && head16bytes[4] == 60 && head16bytes[5] == 0 && head16bytes[6] == 0 && head16bytes[7] == 0 && head16bytes[8] == 63 && head16bytes[9] == 0 && head16bytes[10] == 0 && head16bytes[11] == 0 && head16bytes[12] == 120 && head16bytes[13] == 0 && head16bytes[14] == 0 && head16bytes[15] == 0) {
            return MimeType.of("application/xml");
        }
        byte[] bytes = new byte[head16bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)head16bytes[i];
        }
        String s = new String(bytes, StandardCharsets.UTF_8).replaceAll("\\s", "");
        if (s.startsWith("{\"") || s.startsWith("[{") || s.startsWith("[\"") || s.matches("^\\[\\d.*")) {
            return MimeType.of("application/json");
        }
        return BINARY;
    }

    private void parse(String rawdata) throws Exception {
        int slashIndex = rawdata.indexOf(47);
        int semIndex = rawdata.indexOf(59);
        if (slashIndex < 0 && semIndex < 0) {
            throw new Exception("Unable to find a sub type.");
        }
        if (slashIndex < 0) {
            throw new Exception("Unable to find a sub type.");
        }
        String r = rawdata.substring(0, slashIndex).trim().toLowerCase();
        if (semIndex < 0) {
            this.primaryType = r;
            this.subType = rawdata.substring(slashIndex + 1).trim().toLowerCase();
            this.parameters = new ParamsList();
        } else if (slashIndex < semIndex) {
            this.primaryType = r;
            this.subType = rawdata.substring(slashIndex + 1, semIndex).trim().toLowerCase();
            this.parameters = new ParamsList(rawdata.substring(semIndex));
        } else {
            throw new Exception("Unable to find a sub type.");
        }
        if (!this.isValidToken(this.primaryType)) {
            throw new Exception("Primary type is invalid.");
        }
        if (!this.isValidToken(this.subType)) {
            throw new Exception("Sub type is invalid.");
        }
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String primary) throws Exception {
        if (!this.isValidToken(this.primaryType)) {
            throw new Exception("Primary type is invalid.");
        }
        this.primaryType = primary.toLowerCase();
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String sub) throws Exception {
        if (!this.isValidToken(this.subType)) {
            throw new Exception("Sub type is invalid.");
        }
        this.subType = sub.toLowerCase();
    }

    public ParamsList getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.set(name, value);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public String toString() {
        return this.getBaseType() + this.parameters.toString();
    }

    public String getBaseType() {
        return this.primaryType + "/" + this.subType;
    }

    public boolean match(MimeType type) {
        return this.primaryType.equals(type.getPrimaryType()) && (this.subType.equals("*") || type.getSubType().equals("*") || this.subType.equals(type.getSubType()));
    }

    public boolean match(String rawdata) throws Exception {
        return this.match(new MimeType(rawdata));
    }

    private boolean isValidToken(String s) {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (MimeType.isTokenChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class ParamsList {
        private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";
        private final Map<String, String> parameters = new HashMap<String, String>();

        public ParamsList() {
        }

        public ParamsList(String parameterList) throws Exception {
            this.parse(parameterList);
        }

        private static boolean isTokenChar(char c) {
            return c > ' ' && c < '\u007f' && "()<>@,;:/[]?=\\\"".indexOf(c) < 0;
        }

        private static int skipWhiteSpace(String rawdata, int i) {
            int length = rawdata.length();
            while (i < length && Character.isWhitespace(rawdata.charAt(i))) {
                ++i;
            }
            return i;
        }

        private static String quote(String value) {
            boolean needsQuotes = false;
            int length = value.length();
            for (int i = 0; i < length && !needsQuotes; ++i) {
                needsQuotes = !ParamsList.isTokenChar(value.charAt(i));
            }
            if (needsQuotes) {
                StringBuilder buffer = new StringBuilder();
                buffer.ensureCapacity((int)((double)length * 1.5));
                buffer.append('\"');
                for (int i = 0; i < length; ++i) {
                    char c = value.charAt(i);
                    if (c == '\\' || c == '\"') {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                }
                buffer.append('\"');
                return buffer.toString();
            }
            return value;
        }

        private static String unquote(String value) {
            int valueLength = value.length();
            StringBuilder buffer = new StringBuilder();
            buffer.ensureCapacity(valueLength);
            boolean escaped = false;
            for (int i = 0; i < valueLength; ++i) {
                char currentChar = value.charAt(i);
                if (!escaped && currentChar != '\\') {
                    buffer.append(currentChar);
                    continue;
                }
                if (escaped) {
                    buffer.append(currentChar);
                    escaped = false;
                    continue;
                }
                escaped = true;
            }
            return buffer.toString();
        }

        protected void parse(String parameterList) throws Exception {
            char c;
            if (parameterList == null) {
                return;
            }
            int length = parameterList.length();
            if (length == 0) {
                return;
            }
            int i = ParamsList.skipWhiteSpace(parameterList, 0);
            while (i < length && (c = parameterList.charAt(i)) == ';') {
                String value;
                ++i;
                if ((i = ParamsList.skipWhiteSpace(parameterList, i)) >= length) {
                    return;
                }
                int lastIndex = i;
                while (i < length && ParamsList.isTokenChar(parameterList.charAt(i))) {
                    ++i;
                }
                String name = parameterList.substring(lastIndex, i).toLowerCase();
                if ((i = ParamsList.skipWhiteSpace(parameterList, i)) >= length || parameterList.charAt(i) != '=') {
                    throw new Exception("Couldn't find the '=' that separates a parameter name from its value.");
                }
                ++i;
                if ((i = ParamsList.skipWhiteSpace(parameterList, i)) >= length) {
                    throw new Exception("Couldn't find a value for parameter named " + name);
                }
                c = parameterList.charAt(i);
                if (c == '\"') {
                    if (++i >= length) {
                        throw new Exception("Encountered unterminated quoted parameter value.");
                    }
                    lastIndex = i;
                    while (i < length && (c = parameterList.charAt(i)) != '\"') {
                        if (c == '\\') {
                            ++i;
                        }
                        ++i;
                    }
                    if (c != '\"') {
                        throw new Exception("Encountered unterminated quoted parameter value.");
                    }
                    value = ParamsList.unquote(parameterList.substring(lastIndex, i));
                    ++i;
                } else if (ParamsList.isTokenChar(c)) {
                    lastIndex = i;
                    while (i < length && ParamsList.isTokenChar(parameterList.charAt(i))) {
                        ++i;
                    }
                    value = parameterList.substring(lastIndex, i);
                } else {
                    throw new Exception("Unexpected character encountered at index " + i);
                }
                this.parameters.put(name, value);
                i = ParamsList.skipWhiteSpace(parameterList, i);
            }
            if (i < length) {
                throw new Exception("More characters encountered in input than expected.");
            }
        }

        public int size() {
            return this.parameters.size();
        }

        public boolean isEmpty() {
            return this.parameters.isEmpty();
        }

        public String get(String name) {
            return this.parameters.get(name.trim().toLowerCase());
        }

        public void set(String name, String value) {
            this.parameters.put(name.trim().toLowerCase(), value);
        }

        public void remove(String name) {
            this.parameters.remove(name.trim().toLowerCase());
        }

        public Collection<String> getNames() {
            return this.parameters.keySet();
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (String key : this.parameters.keySet()) {
                s.append("; ").append(key).append('=').append(ParamsList.quote(this.parameters.get(key)));
            }
            return s.toString();
        }
    }
}

