/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers.endpoint;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.logdoc.fairhttp.service.api.helpers.endpoint.InvokerFactory;
import org.logdoc.fairhttp.service.api.helpers.endpoint.Signature;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.RequestInvoker;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.helpers.Texts;

public class Endpoint
implements Comparable<Endpoint> {
    private final String method;
    private final Signature signature;
    private final RequestInvoker invoker;

    public Endpoint(String method, String endpoint, BiFunction<Request, Map<String, String>, CompletionStage<Response>> callback) {
        this.method = Texts.notNull((Object)method).trim().toUpperCase();
        this.signature = new Signature(endpoint);
        this.invoker = callback::apply;
    }

    public Endpoint(String line) throws NoSuchMethodException {
        int idx = line.indexOf(35);
        if (idx != -1 || (idx = line.indexOf("//")) != -1) {
            line = line.substring(0, idx).trim();
        }
        if (line.trim().isEmpty()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String[] pretend = line.split("\\s+", 3);
        if (pretend.length != 3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.method = pretend[0].toUpperCase();
        this.signature = new Signature(pretend[1]);
        this.invoker = InvokerFactory.build(pretend[2]);
        if (this.invoker == null) {
            throw new NoSuchMethodException("Cant build endpoint handler");
        }
    }

    public boolean match(String method, String hardPath) {
        return this.method.equals(method) && this.signature.matches(hardPath);
    }

    public CompletionStage<? extends Response> call(Request request) {
        return (CompletionStage)this.invoker.apply(request, this.signature.values(request.path()));
    }

    @Override
    public int compareTo(Endpoint o) {
        int res = this.method.compareTo(o.method);
        return res == 0 ? this.signature.compareTo(o.signature) : res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.method.equals(((Endpoint)o).method) && this.signature.equals(endpoint.signature);
    }

    public boolean equals(String method, String signature) {
        return this.method.equals(method) && this.signature.equalString(signature);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.signature);
    }

    public String toString() {
        return this.method + "\t" + this.signature;
    }

    public boolean pathMatch(String hardPath) {
        return this.signature.matches(hardPath);
    }
}

