/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers.endpoint;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.UnknownFormatFlagsException;
import java.util.stream.Collectors;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.ArgumentDefinition;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.BodyOnlyAsyncInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.BodyOnlyInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.BodyRequestAsyncInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.BodyRequestInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.DynamicAsyncInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.DynamicInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.EmptyAsyncInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.EmptyInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.RequestBodyAsyncInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.RequestBodyInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.RequestInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.RequestOnlyAsyncInvoker;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.RequestOnlyInvoker;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.helpers.Reflects;
import org.logdoc.helpers.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InvokerFactory {
    private static final Logger logger = LoggerFactory.getLogger(InvokerFactory.class);

    InvokerFactory() {
    }

    private static Args buildArgs(String data) {
        if (Texts.notNull((Object)data).isBlank()) {
            return null;
        }
        return new Args(data.trim());
    }

    private static Class<?> doClassName(String data) throws ClassNotFoundException {
        if (Texts.isEmpty((Object)data)) {
            return null;
        }
        if (data.indexOf(46) != -1) {
            return Class.forName(data);
        }
        switch (data.trim()) {
            case "int": 
            case "Int": {
                return Integer.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": 
            case "Char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "Integer": 
            case "integer": {
                return Integer.class;
            }
            case "Character": 
            case "character": {
                return Character.class;
            }
            case "Short": {
                return Short.class;
            }
            case "Long": {
                return Long.class;
            }
            case "Double": {
                return Double.class;
            }
            case "Float": {
                return Float.class;
            }
            case "Boolean": {
                return Boolean.class;
            }
            case "Json": 
            case "json": {
                return JsonNode.class;
            }
        }
        return String.class;
    }

    static RequestInvoker build(String invokerData) {
        try {
            Args args = InvokerFactory.doInvokerData(invokerData);
            if (Response.class.isAssignableFrom(args.targetMethod.getReturnType())) {
                if (args.size() == 0) {
                    return new EmptyInvoker(args.targetMethod);
                }
                if (args.size() == 1) {
                    ArgData ad = (ArgData)args.get(0);
                    if (ad.container == ArgumentDefinition.Container.Request) {
                        return new RequestOnlyInvoker(args.targetMethod);
                    }
                    if (ad.container == ArgumentDefinition.Container.Body) {
                        return new BodyOnlyInvoker(args.targetMethod, ad.cls);
                    }
                }
                if (args.size() == 2) {
                    ArgData fd = (ArgData)args.get(0);
                    ArgData sd = (ArgData)args.get(1);
                    if (fd.container == ArgumentDefinition.Container.Body && sd.container == ArgumentDefinition.Container.Request) {
                        return new BodyRequestInvoker(args.targetMethod, fd.cls);
                    }
                    if (fd.container == ArgumentDefinition.Container.Request && sd.container == ArgumentDefinition.Container.Body) {
                        return new RequestBodyInvoker(args.targetMethod, sd.cls);
                    }
                }
                return new DynamicInvoker(args.targetMethod, args.stream().map(ad0 -> new ArgumentDefinition(ad0.container, ad0.cls, ad0.name)).collect(Collectors.toList()));
            }
            if (args.size() == 0) {
                return new EmptyAsyncInvoker(args.targetMethod);
            }
            if (args.size() == 1) {
                ArgData ad = (ArgData)args.get(0);
                if (ad.container == ArgumentDefinition.Container.Request) {
                    return new RequestOnlyAsyncInvoker(args.targetMethod);
                }
                if (ad.container == ArgumentDefinition.Container.Body) {
                    return new BodyOnlyAsyncInvoker(args.targetMethod, ad.cls);
                }
            }
            if (args.size() == 2) {
                ArgData fd = (ArgData)args.get(0);
                ArgData sd = (ArgData)args.get(1);
                if (fd.container == ArgumentDefinition.Container.Body && sd.container == ArgumentDefinition.Container.Request) {
                    return new BodyRequestAsyncInvoker(args.targetMethod, fd.cls);
                }
                if (fd.container == ArgumentDefinition.Container.Request && sd.container == ArgumentDefinition.Container.Body) {
                    return new RequestBodyAsyncInvoker(args.targetMethod, sd.cls);
                }
            }
            return new DynamicAsyncInvoker(args.targetMethod, args.stream().map(ad0 -> new ArgumentDefinition(ad0.container, ad0.cls, ad0.name)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            logger.error(invokerData + " :: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Args doInvokerData(String invokerData) throws Exception {
        int parenth = (invokerData = invokerData.replace("()", "")).indexOf(40);
        String signature = parenth > 0 ? invokerData.substring(0, parenth) : invokerData;
        Args args = parenth > 0 ? InvokerFactory.buildArgs(invokerData.substring(parenth + 1, invokerData.lastIndexOf(41))) : null;
        int lastDot = signature.lastIndexOf(46);
        String clsName = signature.substring(0, lastDot);
        String mthName = signature.substring(lastDot + 1);
        Class<?> cls = Class.forName(clsName);
        Method method = null;
        Set allMethods = Reflects.getAllMethods(cls);
        for (Method m : allMethods) {
            if (!m.getName().equals(mthName)) continue;
            if (args == null) {
                if (m.getParameterCount() == 0) {
                    method = m;
                    break;
                }
                if (m.getParameterCount() != 1 || !Request.class.isAssignableFrom(m.getParameterTypes()[0])) continue;
                method = m;
                break;
            }
            if (!args.match(m)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new NoSuchMethodException(invokerData);
        }
        if (args == null) {
            Args a = new Args("");
            a.targetMethod = method;
            return a;
        }
        args.targetMethod = method;
        return args;
    }

    private static class Args
    extends ArrayList<ArgData> {
        Method targetMethod;

        private Args(String data) {
            if (!Texts.isEmpty((Object)data)) {
                Arrays.stream(data.split(",")).map(d -> d.replaceAll("\\s", "")).filter(d -> !d.trim().isBlank()).map(d -> {
                    try {
                        long rightCount;
                        ArgData ad = new ArgData();
                        int left = d.indexOf(91);
                        int right = d.indexOf(93);
                        if (left != -1 && right == -1 || left == -1 && right != -1) {
                            throw new UnknownFormatFlagsException((String)d);
                        }
                        long leftCount = d.chars().filter(c -> c == 91).count();
                        if (leftCount != (rightCount = d.chars().filter(c -> c == 93).count()) || leftCount > 2L) {
                            throw new UnknownFormatFlagsException((String)d);
                        }
                        if (left == -1) {
                            ad.container = ArgumentDefinition.Container.Unknown;
                            ad.name = d;
                            ad.cls = String.class;
                        } else if (leftCount == 1L) {
                            if (left == 0) {
                                if (right == d.length() - 1) {
                                    ad.container = ArgumentDefinition.Container.valueOf(d.substring(left + 1, right));
                                    if (ad.container == ArgumentDefinition.Container.Request) {
                                        ad.cls = Request.class;
                                    } else if (ad.container != ArgumentDefinition.Container.Body) {
                                        throw new UnknownFormatFlagsException((String)d);
                                    }
                                } else {
                                    ad.cls = InvokerFactory.doClassName(d.substring(left + 1, right));
                                    ad.container = ArgumentDefinition.Container.Unknown;
                                }
                            } else {
                                ad.container = ArgumentDefinition.Container.valueOf(d.substring(left + 1, right));
                                ad.name = d.substring(0, left);
                                if (ad.container != ArgumentDefinition.Container.Request && ad.container != ArgumentDefinition.Container.Body) {
                                    ad.cls = String.class;
                                }
                            }
                        } else {
                            ad.cls = InvokerFactory.doClassName(d.substring(left + 1, right));
                            left = d.lastIndexOf(91);
                            ad.container = ArgumentDefinition.Container.valueOf(d.substring(left + 1, d.length() - 1));
                            ad.name = d.substring(right + 1, left);
                        }
                        return ad;
                    }
                    catch (Exception e) {
                        logger.error("Cant parse args = " + d + " :: " + e.getMessage(), (Throwable)e);
                        return null;
                    }
                }).filter(Objects::nonNull).forEach(this::add);
            }
        }

        public boolean match(Method m) {
            if (this.size() > m.getParameterCount()) {
                return false;
            }
            Class<?>[] types = m.getParameterTypes();
            if (types.length - this.size() > 1) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                ArgData ad = (ArgData)this.get(i);
                Class<?> cls = types[i];
                if (cls.equals(Request.class) && ad.cls != null && !ad.cls.equals(cls)) {
                    ArgData msd = new ArgData();
                    msd.cls = Request.class;
                    msd.container = ArgumentDefinition.Container.Request;
                    this.add(i--, msd);
                    continue;
                }
                if (ad.cls == null) {
                    ad.cls = cls;
                }
                if (cls.isAssignableFrom(ad.cls)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(ArgData argData) {
            if (argData == null) {
                throw new NullPointerException();
            }
            return super.add(argData);
        }
    }

    private static class ArgData {
        String name;
        Class<?> cls;
        ArgumentDefinition.Container container;

        private ArgData() {
        }

        public String toString() {
            return "ArgData{name='" + this.name + "', cls=" + this.cls + ", container=" + this.container + "}";
        }
    }
}

