/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers.endpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Signature
implements Comparable<Signature> {
    private static final Pattern placeHold = Pattern.compile("/:([^/]+)");
    private final int weight;
    private final String string;
    private final Pattern pattern;
    private final List<String> names;

    Signature(String raw) {
        String proper = raw.trim().replaceAll("/{2,}", "/");
        Matcher phm = placeHold.matcher(proper);
        if (phm.find()) {
            this.names = new ArrayList<String>(4);
            do {
                this.names.add(phm.group(1));
            } while (phm.find());
            this.pattern = Pattern.compile("^" + proper.replaceAll(placeHold.pattern(), "/([^/]+)") + "$");
            this.string = this.pattern.pattern();
        } else {
            this.string = proper;
            this.pattern = null;
            this.names = null;
        }
        int cnt = 0;
        for (int i = 0; i < this.string.length(); ++i) {
            if (this.string.charAt(i) != '/') continue;
            ++cnt;
        }
        this.weight = cnt;
    }

    boolean matches(String hardPath) {
        if (this.pattern != null) {
            return this.pattern.matcher(hardPath).matches();
        }
        return this.string.equals(hardPath);
    }

    Map<String, String> values(String hardPath) {
        if (this.pattern == null) {
            return Collections.emptyMap();
        }
        Matcher m = this.pattern.matcher(hardPath);
        HashMap<String, String> values = new HashMap<String, String>(4);
        if (m.matches()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                values.put(this.names.get(i), m.group(i + 1));
            }
        }
        return values;
    }

    @Override
    public int compareTo(Signature o) {
        int res = Integer.compare(this.weight, o.weight);
        return res == 0 ? this.string.compareTo(o.string) : res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return this.weight == signature.weight && this.string.equals(signature.string);
    }

    public int hashCode() {
        return Objects.hash(this.weight, this.string);
    }

    public String toString() {
        return this.string;
    }

    boolean equalString(String signature) {
        return this.string.equals(signature);
    }
}

