/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers.endpoint.invokers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.tools.Form;
import org.logdoc.fairhttp.service.tools.Json;
import org.logdoc.fairhttp.service.tools.MultiForm;
import org.logdoc.helpers.Digits;
import org.logdoc.helpers.Texts;

public class ArgumentDefinition {
    private final Container container;
    private final Class<?> argClass;
    private final String paramName;

    public ArgumentDefinition(Container container, Class<?> argClass, String paramName) {
        this.container = container;
        this.argClass = argClass;
        this.paramName = paramName;
    }

    Object resolve(Map<String, String> query, Map<String, String> cookies, Form form, MultiForm multiForm, Map<String, String> pathMap, JsonNode jsonBody, Request request) {
        if (this.container == Container.Request) {
            return request;
        }
        Object value = null;
        switch (this.container) {
            case Body: {
                value = jsonBody == null || this.argClass.equals(JsonNode.class) ? jsonBody : Json.fromJson(jsonBody, this.argClass);
                break;
            }
            case Cookie: {
                value = Texts.isEmpty(cookies) ? null : cookies.get(this.paramName);
                break;
            }
            case Form: {
                value = Texts.isEmpty((Object)form) && Texts.isEmpty((Object)multiForm) ? null : (Texts.isEmpty((Object)multiForm) ? form.get(this.paramName) : multiForm.get(this.paramName));
                break;
            }
            case Query: {
                value = Texts.isEmpty(query) ? null : query.get(this.paramName);
                break;
            }
            case Path: {
                value = pathMap.get(this.paramName);
                break;
            }
            case Unknown: {
                String string = value = !Texts.isEmpty(pathMap) ? pathMap.get(this.paramName) : null;
                if (value != null) break;
                String string2 = value = !Texts.isEmpty(query) ? query.get(this.paramName) : null;
                if (value != null) break;
                String string3 = value = !Texts.isEmpty(cookies) ? cookies.get(this.paramName) : null;
                if (value != null) break;
                List mf = !Texts.isEmpty((Object)form) ? (List)form.get(this.paramName) : null;
                Object object = value = Texts.isEmpty(mf) ? null : (Object)mf.get(0);
                if (value != null || Texts.isEmpty((Object)multiForm)) break;
                try {
                    value = ((MultiForm.Part)multiForm.get((Object)this.paramName)).value;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (value == null || CharSequence.class.isAssignableFrom(this.argClass) || this.argClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.argClass.equals(Short.TYPE) || this.argClass.equals(Short.class)) {
            return Digits.getShort((Object)value);
        }
        if (this.argClass.equals(Integer.TYPE) || this.argClass.equals(Integer.class)) {
            return Digits.getInt((Object)value);
        }
        if (this.argClass.equals(Long.TYPE) || this.argClass.equals(Long.class)) {
            return Digits.getLong((Object)value);
        }
        if (this.argClass.equals(Double.TYPE) || this.argClass.equals(Double.class)) {
            return Digits.getDouble((Object)value);
        }
        if (this.argClass.equals(Float.TYPE) || this.argClass.equals(Float.class)) {
            return Float.valueOf(Digits.getFloat((Object)value));
        }
        if (this.argClass.equals(Boolean.TYPE) || this.argClass.equals(Boolean.class)) {
            return Texts.getBoolean((Object)value);
        }
        if (this.argClass.equals(Character.TYPE) || this.argClass.equals(Character.class)) {
            if (!CharSequence.class.isAssignableFrom(value.getClass())) {
                value = String.valueOf(value);
            }
            if (Texts.isEmpty((Object)value)) {
                return this.argClass.equals(Character.TYPE) ? Character.valueOf('\u0000') : null;
            }
            return Character.valueOf(((CharSequence)value).charAt(0));
        }
        if (this.argClass.equals(Byte.TYPE) || this.argClass.equals(Byte.class)) {
            if (!CharSequence.class.isAssignableFrom(value.getClass())) {
                value = String.valueOf(value);
            }
            if (Texts.isEmpty((Object)value)) {
                return this.argClass.equals(Byte.TYPE) ? Character.valueOf('\u0000') : null;
            }
            return Byte.parseByte((String)value);
        }
        return value;
    }

    public static enum Container {
        Form,
        Body,
        Query,
        Cookie,
        Path,
        Unknown,
        Request;

    }
}

