/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers.endpoint.invokers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.logdoc.fairhttp.service.DI;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.ArgumentDefinition;
import org.logdoc.fairhttp.service.api.helpers.endpoint.invokers.RequestInvoker;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.tools.Form;
import org.logdoc.fairhttp.service.tools.MultiForm;

public class DynamicInvoker
implements RequestInvoker {
    private final List<ArgumentDefinition> args;
    private final Method targetMethod;

    public DynamicInvoker(Method targetMethod, List<ArgumentDefinition> args) {
        this.args = args;
        this.targetMethod = targetMethod;
    }

    @Override
    public CompletionStage<Response> apply(Request request, Map<String, String> pathMap) {
        MultiForm multiForm;
        Map<String, String> query = request.queryMap();
        Map<String, String> cookies = request.cookies();
        Form form = request.body().asForm();
        try {
            multiForm = request.body().asMultipart();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonNode json = request.body().asJson();
        try {
            Object[] params = new Object[this.args.size()];
            int i = 0;
            for (ArgumentDefinition ad : this.args) {
                params[i++] = ad.resolve(query, cookies, form, multiForm, pathMap, json, request);
            }
            return CompletableFuture.completedFuture((Response)this.targetMethod.invoke(DI.gain(this.targetMethod.getDeclaringClass()), params));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }
}

