/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.helpers.Texts;

class CORS {
    private static final String OriginReply = "Access-Control-Allow-Origin";
    private static final String MethodReply = "Access-Control-Allow-Methods";
    private static final String HeadersReply = "Access-Control-Allow-Headers";
    private static final String ExposeReply = "Access-Control-Expose-Headers";
    private static final String CredsReply = "Access-Control-Allow-Credentials";
    private static final String OriginRequest = "Origin";
    private static final String MethodRequest = "Access-control-request-method";
    private static final String HeadersRequest = "Access-control-request-headers";
    private final String originStr;
    private final String methodsStr;
    private final String headersStr;
    private final String allowCreds;
    private final String exposeStr;
    private final boolean noWilds;
    private final boolean multiOrigins;

    CORS(Config config) {
        boolean allowCreds;
        Config cors = config != null && config.hasPath("fair.http.cors") ? config.getConfig("fair.http.cors") : null;
        HashSet<String> origins = new HashSet<String>();
        HashSet<String> methods = new HashSet<String>();
        HashSet<String> headers = new HashSet<String>();
        HashSet<String> expose = new HashSet<String>();
        boolean bl = allowCreds = cors == null || cors.isEmpty() || !cors.hasPath("allow_credentials") || cors.getBoolean("allow_credentials");
        if (cors != null && !cors.isEmpty()) {
            this.setCorsValues(cors, "origins", origins);
            this.setCorsValues(cors, "methods", methods);
            this.setCorsValues(cors, "headers", headers);
            this.setCorsValues(cors, "expose", expose);
        }
        this.originStr = Texts.notNull((Object)(Texts.isEmpty(origins) ? "*" : origins.stream().map(String::trim).filter(s -> !Texts.isEmpty((Object)s)).collect(Collectors.joining(", "))), (String)"*");
        this.methodsStr = Texts.notNull((Object)(Texts.isEmpty(methods) ? "*" : methods.stream().map(String::trim).filter(s -> !Texts.isEmpty((Object)s)).collect(Collectors.joining(", "))), (String)"*");
        this.headersStr = Texts.notNull((Object)(Texts.isEmpty(headers) ? "*" : headers.stream().map(String::trim).filter(s -> !Texts.isEmpty((Object)s)).collect(Collectors.joining(", "))), (String)"*");
        this.exposeStr = Texts.notNull((Object)(Texts.isEmpty(expose) ? "*" : expose.stream().map(String::trim).filter(s -> !Texts.isEmpty((Object)s)).collect(Collectors.joining(", "))), (String)"*");
        this.noWilds = !this.originStr.equals("*") && !this.methodsStr.equals("*") && !this.headersStr.equals("*") && !this.exposeStr.equals("*");
        this.multiOrigins = this.originStr.contains(",");
        this.allowCreds = String.valueOf(allowCreds);
    }

    private void setCorsValues(Config cors, String path, Set<String> target) {
        if (cors.hasPath(path)) {
            try {
                target.addAll(new ArrayList(cors.getStringList(path)));
            }
            catch (Exception ignore) {
                try {
                    target.add(cors.getString(path));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    Response wrap(Request request, Response response) {
        if (this.multiOrigins) {
            response.header("Vary", "origin");
        }
        if (!request.hasHeader("Authorization") && !request.hasHeader("Cookie") || this.noWilds) {
            return response.withHeader(OriginReply, this.originStr).withHeader(MethodReply, this.methodsStr).withHeader(HeadersReply, this.headersStr).withHeader(ExposeReply, this.exposeStr).withHeader(CredsReply, this.allowCreds);
        }
        if (request.hasHeader(MethodRequest)) {
            response.header(MethodReply, this.methodsStr.equals("*") ? request.header(MethodRequest) : this.methodsStr);
        }
        if (request.hasHeader(HeadersRequest)) {
            response.header(HeadersReply, this.headersStr.equals("*") ? request.header(HeadersRequest) : this.headersStr);
        }
        if (!this.exposeStr.equals("*")) {
            response.header(ExposeReply, this.exposeStr);
        }
        return response.withHeader(OriginReply, this.originStr.equals("*") ? request.header(OriginRequest) : this.originStr).withHeader(CredsReply, this.allowCreds);
    }
}

