/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import java.net.HttpCookie;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.logdoc.helpers.Texts;

public class Cookie {
    private static final String tspecials = ",; ";
    private final String name;
    private final long whenCreated;
    private String value;
    private String domain;
    private long maxAge = -1L;
    private String path;
    private String portlist;
    private boolean secure;
    private boolean httpOnly;
    private int version = 1;
    private SameSite sameSite;

    public Cookie(String name, String value) {
        if (Texts.isEmpty((Object)name) || !this.isToken(name) || name.charAt(0) == '$') {
            throw new IllegalArgumentException("Illegal cookie name");
        }
        this.name = name.trim();
        this.value = value;
        this.secure = false;
        this.whenCreated = System.currentTimeMillis();
        this.portlist = null;
    }

    public Cookie(String name, String value, Integer maxAge, String path, String domain, boolean secure, boolean httpOnly, SameSite sameSite) {
        this.name = name;
        this.value = value;
        this.maxAge = maxAge.intValue();
        this.path = path;
        this.domain = domain;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
        this.whenCreated = System.currentTimeMillis();
    }

    public static Builder builder(String name, String value) {
        return new Builder(name, value);
    }

    public String getName() {
        return this.name;
    }

    public long getWhenCreated() {
        return this.whenCreated;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPortlist() {
        return this.portlist;
    }

    public void setPortlist(String portlist) {
        this.portlist = portlist;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    private boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public void setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("=\"").append(this.getValue()).append('\"');
        if (this.getPath() != null) {
            sb.append("; Path=\"").append(this.getPath()).append('\"');
        }
        if (this.getDomain() != null) {
            sb.append("; Domain=\"").append(this.getDomain()).append('\"');
        }
        if (this.getPortlist() != null) {
            sb.append("; Port=\"").append(this.getPortlist()).append('\"');
        }
        if (this.getMaxAge() > -1L) {
            sb.append("; Expires=").append(LocalDateTime.now().plus(this.getMaxAge(), ChronoUnit.SECONDS).atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        }
        if (this.isSecure()) {
            sb.append("; Secure");
        }
        if (this.isHttpOnly()) {
            sb.append("; HttpOnly");
        }
        if (this.getSameSite() != null) {
            sb.append("; SameSite=\"").append(this.getSameSite().value()).append('\"');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpCookie)) {
            return false;
        }
        HttpCookie other = (HttpCookie)obj;
        return this.equalsIgnoreCase(this.getName(), other.getName()) && this.equalsIgnoreCase(this.getDomain(), other.getDomain()) && Objects.equals(this.getPath(), other.getPath());
    }

    public int hashCode() {
        int h1 = this.name.toLowerCase().hashCode();
        int h2 = this.domain != null ? this.domain.toLowerCase().hashCode() : 0;
        int h3 = this.path != null ? this.path.hashCode() : 0;
        return h1 + h2 + h3;
    }

    private boolean equalsIgnoreCase(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            return s.equalsIgnoreCase(t);
        }
        return false;
    }

    public static class Builder {
        private String name;
        private String value;
        private Integer maxAge;
        private String path = "/";
        private String domain;
        private boolean secure = false;
        private boolean httpOnly = true;
        private SameSite sameSite;

        private Builder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withMaxAge(Duration maxAge) {
            this.maxAge = (int)maxAge.getSeconds();
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder withHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder withSameSite(SameSite sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.maxAge, this.path, this.domain, this.secure, this.httpOnly, this.sameSite);
        }
    }

    public static enum SameSite {
        STRICT("Strict"),
        LAX("Lax"),
        NONE("None");

        private final String value;

        private SameSite(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

