/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.Server;
import org.logdoc.fairhttp.service.http.WebSocket;
import org.logdoc.helpers.Digits;
import org.logdoc.helpers.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Handler.class);
    private final Server server;
    private final Socket socket;
    private final String id;
    private final int maxRequestSize;
    private final int readTimeout;

    Handler(Socket socket, Server server, int maxRequestSize, int readTimeout) {
        this.server = server;
        this.socket = socket;
        this.readTimeout = readTimeout;
        this.maxRequestSize = maxRequestSize;
        this.id = socket.getRemoteSocketAddress().toString();
        this.setDaemon(true);
    }

    @Override
    public void run() {
        int i;
        byte[] head = new byte[8192];
        try {
            byte[] end = new byte[]{13, 10};
            this.socket.setSoTimeout(this.readTimeout);
            InputStream is = this.socket.getInputStream();
            for (i = 0; i <= head.length; ++i) {
                head[i] = (byte)is.read();
                if (i <= 4 || end[0] != head[i - 3] || end[1] != head[i - 2] || end[0] != head[i - 1] || end[1] != head[i]) continue;
                head = Arrays.copyOfRange(head, 0, i - 3);
                break;
            }
            if (i < 10) {
                logger.error(this.id + " :: Insufficient request, only " + i + " bytes read. Drop connection.");
                this.close();
                return;
            }
        }
        catch (SocketTimeoutException e) {
            if (i > 0) {
                logger.error(this.id + " :: Cant read request headers, timed out after " + i + " bytes. Drop connection.");
            }
            this.close();
            return;
        }
        catch (IOException e) {
            logger.error(this.id + " :: Error read request headers. Drop connection.");
            this.close();
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.error(this.id + " :: Headers section is out of the limit 8192 bytes. Drop connection", (Throwable)e);
            this.close();
            return;
        }
        this.server.handleRequest(new Request(this.socket.getRemoteSocketAddress(), head, this::readBody), this::response);
    }

    private byte[] readBody(Request request) {
        byte[] byArray;
        InputStream i = this.socket.getInputStream();
        int contentLength = Digits.getInt((Object)request.header("Content-Length"));
        String te = Texts.notNull((Object)request.header("Transfer-Encoding"));
        boolean chunked = te.contains("chunked");
        boolean gzip = te.contains("gzip");
        boolean deflate = te.contains("deflate");
        if (deflate) {
            i = new InflaterInputStream(i);
        }
        if (gzip) {
            i = new GZIPInputStream(i);
        }
        if (chunked) {
            return this.chunksFrom(i);
        }
        if (contentLength > 0) {
            byte[] data = new byte[contentLength];
            for (int j = 0; j < contentLength; ++j) {
                data[j] = (byte)i.read();
            }
            return data;
        }
        this.socket.setSoTimeout(this.readTimeout);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.maxRequestSize == 0 ? 0x2000000 : this.maxRequestSize);
        try {
            byte[] buf = new byte[1024];
            int sum = 0;
            try {
                int read;
                do {
                    if ((read = i.read()) <= 0) continue;
                    bos.write(buf, 0, read);
                    sum += read;
                } while (read != -1 && (this.maxRequestSize <= 0 || sum < this.maxRequestSize));
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            bos.flush();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(this.id + " :: " + e.getMessage(), (Throwable)e);
                return new byte[0];
            }
        }
        bos.close();
        return byArray;
    }

    private byte[] chunksFrom(InputStream is) throws IOException {
        this.socket.setSoTimeout(this.readTimeout);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(this.maxRequestSize == 0 ? 0x2000000 : this.maxRequestSize);){
            int chunkSize;
            int sum = 0;
            do {
                if ((chunkSize = this.getChunkSize(is)) <= 0) continue;
                if (this.maxRequestSize > 0 && (sum += chunkSize) > this.maxRequestSize) {
                    throw new IllegalStateException("Max request size is exceeded: " + this.maxRequestSize);
                }
                for (int i = 0; i < chunkSize; ++i) {
                    bos.write(is.read());
                }
            } while (chunkSize > 0);
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private int getChunkSize(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(8);){
            int b;
            do {
                if (Character.digit(b = is.read(), 16) == -1) continue;
                os.write(b);
            } while (b != 10);
            int n = Integer.parseInt(os.toString(StandardCharsets.US_ASCII), 16);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void response(Response response) {
        if (response instanceof WebSocket) {
            ((WebSocket)response).spinOff(this.socket);
            return;
        }
        try (OutputStream os = this.socket.getOutputStream();){
            byte[] data = response.asBytes();
            if (data != null && data.length > 0) {
                os.write(data);
                os.flush();
            }
        }
        catch (Exception e) {
            logger.error(this.id + " :: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    void close() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

