/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.logdoc.fairhttp.service.api.helpers.MimeType;
import org.logdoc.fairhttp.service.tools.Form;
import org.logdoc.fairhttp.service.tools.HttpBinStreaming;
import org.logdoc.fairhttp.service.tools.Json;
import org.logdoc.fairhttp.service.tools.MultiForm;
import org.logdoc.fairhttp.service.tools.Pair;
import org.logdoc.fairhttp.service.tools.ParameterParser;
import org.logdoc.fairhttp.service.tools.websocket.extension.IExtension;
import org.logdoc.fairhttp.service.tools.websocket.protocol.IProtocol;
import org.logdoc.helpers.Texts;

public class Request {
    private final byte[] rawHead;
    private final Function<Request, byte[]> bodySupplier;
    private final SocketAddress remote;
    private Map<String, String> q;
    private Map<String, String> h;
    private Map<String, String> c;
    private String m;
    private String p;
    private String u;
    private String[] hz;
    private Body b;
    private MimeType t;

    Request(SocketAddress remote, byte[] rawHead, Function<Request, byte[]> bodySupplier) {
        this.rawHead = rawHead;
        this.remote = remote;
        this.bodySupplier = bodySupplier;
    }

    public boolean isWebsocketUpgradable() {
        return this.isWebsocketUpgradable(null, null);
    }

    public boolean isWebsocketUpgradable(IExtension extension) {
        return this.isWebsocketUpgradable(extension, null);
    }

    public boolean isWebsocketUpgradable(IExtension extension, IProtocol protocol) {
        try {
            MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ignore) {
            return false;
        }
        return !(!"13".equals(this.header("Sec-WebSocket-Version")) || extension != null && !extension.acceptProvidedExtensionAsServer(this.header("Sec-WebSocket-Extensions")) || protocol != null && !protocol.acceptProtocol(this.header("Sec-WebSocket-Protocol")));
    }

    public SocketAddress getRemote() {
        return this.remote;
    }

    public String method() {
        if (this.m == null) {
            this.makeFirstLine();
        }
        return this.m;
    }

    public String path() {
        if (this.p == null) {
            this.makeFirstLine();
        }
        return this.p;
    }

    public String uri() {
        if (this.u == null) {
            this.makeFirstLine();
        }
        return this.u;
    }

    public Map<String, String> queryMap() {
        if (this.q == null) {
            this.makeFirstLine();
        }
        return this.q;
    }

    public String queryParam(String name) {
        return this.queryMap().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> headersMap() {
        if (this.h == null) {
            Request request = this;
            synchronized (request) {
                HashMap<String, String> hm = new HashMap<String, String>(8);
                for (int i = 1; i < this.heads().length; ++i) {
                    String name;
                    int idx = this.heads()[i].indexOf(58);
                    if (idx == -1 || (name = Texts.notNull((Object)this.heads()[i].substring(0, idx))).isEmpty()) continue;
                    hm.put(name.toUpperCase(Locale.ROOT), Texts.notNull((Object)this.heads()[i].substring(idx + 1)));
                }
                this.h = Collections.unmodifiableMap(hm);
            }
        }
        return this.h;
    }

    public String header(String name) {
        return this.headersMap().get(Texts.notNull((Object)name).toUpperCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void makeFirstLine() {
        Request request = this;
        synchronized (request) {
            String[] parts = this.heads()[0].split("\\s", 3);
            this.m = parts[0];
            this.u = parts[1];
            if (this.u.indexOf(63) == -1) {
                this.p = this.u;
                this.q = Collections.emptyMap();
            } else {
                this.p = this.u.substring(0, this.u.indexOf(63));
                HashMap qm = new HashMap(4);
                Arrays.stream(this.u.substring(this.u.indexOf(63) + 1).split(Pattern.quote("&"))).map(pair -> pair.split(Pattern.quote("="))).forEach(kv -> qm.put(kv[0], URLDecoder.decode(kv[1], StandardCharsets.UTF_8)));
                this.q = Collections.unmodifiableMap(qm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] heads() {
        if (this.hz == null) {
            Request request = this;
            synchronized (request) {
                this.hz = new String(this.rawHead, StandardCharsets.UTF_8).split("\n");
            }
        }
        return this.hz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Body body() {
        if (this.b == null) {
            Request request = this;
            synchronized (request) {
                this.b = new Body(this.bodySupplier.apply(this), this.contentType());
            }
        }
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeType contentType() {
        if (this.t == null) {
            Request request = this;
            synchronized (request) {
                try {
                    this.t = new MimeType(this.header("Content-Type"));
                }
                catch (Exception e) {
                    this.t = MimeType.BINARY;
                }
            }
        }
        return this.t;
    }

    public boolean hasHeader(String name) {
        return this.header(name) != null;
    }

    public String cookie(String name) {
        return this.cookies().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> cookies() {
        if (this.c == null) {
            Request request = this;
            synchronized (request) {
                HashMap m = new HashMap();
                String v = this.header("Cookie");
                if (!Texts.isEmpty((Object)v)) {
                    Arrays.stream(v.split(";")).filter(s -> s.contains("=")).forEach(c -> {
                        String[] parts = c.split(Pattern.quote("="), 2);
                        if (parts.length != 2) {
                            return;
                        }
                        m.put(Texts.notNull((Object)parts[0]), HttpBinStreaming.stringQuotes(parts[1]));
                    });
                }
                this.c = Collections.unmodifiableMap(m);
            }
        }
        return this.c;
    }

    public static class Body {
        private final MimeType contentType;
        private final byte[] data;
        private Form f;
        private MultiForm m;
        private JsonNode j;

        private Body(byte[] data, MimeType contentType) {
            this.data = data;
            this.contentType = contentType;
        }

        public byte[] asBytes() {
            return Arrays.copyOf(this.data, this.data.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JsonNode asJson() {
            if (this.j == null && this.contentTypeMatch(MimeType.JSON)) {
                Body body = this;
                synchronized (body) {
                    this.j = Json.parse(this.data);
                }
            }
            return this.j;
        }

        public <T> T map(Class<? extends T> klass) {
            return Json.fromJson(this.asJson(), klass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiForm asMultipart() throws IOException {
            if (this.m == null && this.data != null && this.data.length > 0 && this.contentTypeMatch(MimeType.MULTIPART)) {
                Body body = this;
                synchronized (body) {
                    this.m = new MultiForm();
                    List<Pair<Integer, Integer>> positions = HttpBinStreaming.markParts(this.data, HttpBinStreaming.getBoundary(this.contentType));
                    for (Pair<Integer, Integer> partMark : positions) {
                        AtomicReference<MimeType> cTypeHold = new AtomicReference<MimeType>(MimeType.TEXTPLAIN);
                        HashMap<String, String> partHeaders = new HashMap<String, String>(8){

                            @Override
                            public String put(String key, String value) {
                                return super.put(key.toUpperCase(), value);
                            }

                            @Override
                            public String get(Object key) {
                                return (String)super.get(String.valueOf(key).toUpperCase());
                            }
                        };
                        try (ByteArrayOutputStream tempo = new ByteArrayOutputStream(256);){
                            AtomicBoolean inHead = new AtomicBoolean(true);
                            Consumer<Byte> headersConsumer = HttpBinStreaming.headersTicker(tempo, len -> {}, chunked -> {}, cTypeHold::set, partHeaders::put, (n, v) -> {}, unused -> tempo.reset(), unused -> {
                                tempo.reset();
                                inHead.set(false);
                            });
                            Consumer<Byte> bodyConsumer = tempo::write;
                            for (int i = ((Integer)partMark.first).intValue(); i < (Integer)partMark.second; ++i) {
                                if (inHead.get()) {
                                    headersConsumer.accept(this.data[i]);
                                    continue;
                                }
                                bodyConsumer.accept(this.data[i]);
                            }
                            String cd = (String)partHeaders.get("Content-disposition");
                            if (cd == null) continue;
                            String fileName = null;
                            String fieldName = null;
                            String cdl = cd.trim().toLowerCase();
                            if (cdl.startsWith("form-data") || cdl.startsWith("attachment")) {
                                try {
                                    ParameterParser parser = new ParameterParser();
                                    parser.setLowerCaseNames();
                                    Map<String, String> parameters = parser.parse(cd, ';');
                                    fileName = parameters.get("filename");
                                    fieldName = parameters.get("name");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (Texts.isEmpty(fieldName)) continue;
                            if (!Texts.isEmpty(fileName)) {
                                this.m.fileData(fieldName, fileName, tempo.toByteArray(), cTypeHold.get());
                                continue;
                            }
                            if (cTypeHold.get().getBaseType().startsWith("text/")) {
                                this.m.textData(fieldName, tempo.toString(StandardCharsets.UTF_8));
                                continue;
                            }
                            this.m.binData(fieldName, tempo.toByteArray(), (Map<String, String>)partHeaders);
                        }
                    }
                }
            }
            return this.m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Form asForm() {
            if (this.f == null && this.data != null && this.data.length > 0 && this.contentTypeMatch(MimeType.FORM)) {
                Body body = this;
                synchronized (body) {
                    this.f = new Form();
                    String fdata = new String(this.data, StandardCharsets.UTF_8);
                    Arrays.stream(fdata.split(Pattern.quote("&"))).map((? super T pair) -> pair.split(Pattern.quote("="))).forEach(kv -> {
                        String v = URLDecoder.decode(kv[1], StandardCharsets.UTF_8);
                        if (Texts.isEmpty((Object)v)) {
                            if (!this.f.containsKey(kv[0])) {
                                this.f.put(kv[0], new ArrayList(2));
                            }
                            ((List)this.f.get(kv[0])).add(v);
                        }
                    });
                }
            }
            return this.f;
        }

        private boolean contentTypeMatch(MimeType expected) {
            if (this.contentType == null) {
                return expected == null;
            }
            try {
                return this.contentType.match(expected);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

