/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import com.typesafe.config.Config;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.logdoc.fairhttp.service.api.helpers.DynamicRoute;
import org.logdoc.fairhttp.service.api.helpers.endpoint.Endpoint;
import org.logdoc.fairhttp.service.http.CORS;
import org.logdoc.fairhttp.service.http.Handler;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.statics.BundledRead;
import org.logdoc.fairhttp.service.http.statics.DirectRead;
import org.logdoc.fairhttp.service.http.statics.NoStatics;
import org.logdoc.fairhttp.service.tools.ConfigTools;
import org.logdoc.helpers.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private static Server backRef = null;
    private final SortedSet<Endpoint> endpoints;
    private final int port;
    private final int maxRequestBytes;
    private final int readTimeout;
    private final Function<String, Response> assets;
    private final CORS cors;
    private Function<Throwable, Response> errorHandler;

    public Server(int port, int maxRequestBytes) {
        this.port = port;
        this.maxRequestBytes = maxRequestBytes;
        this.readTimeout = 15000;
        this.endpoints = new TreeSet<Endpoint>();
        this.assets = new NoStatics();
        this.cors = new CORS(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server(Config config) {
        Class<Server> clazz = Server.class;
        synchronized (Server.class) {
            if (backRef != null) {
                throw new IllegalStateException("Only one instance can be started");
            }
            backRef = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.port = config.getInt("fair.http.port");
            this.maxRequestBytes = config.getBytes("fair.http.max_request_body").intValue();
            this.readTimeout = (int)config.getDuration("fair.http.request_read_timeout").getSeconds() * 1000;
            this.endpoints = new TreeSet<Endpoint>();
            Config staticsCfg = ConfigTools.sureConf(config, "fair.http.statics");
            String dir = staticsCfg != null && staticsCfg.hasPath("root") && !staticsCfg.getIsNull("root") ? Texts.notNull((Object)staticsCfg.getString("root")) : null;
            Function<String, Response> assets0 = new NoStatics();
            try {
                if (!Texts.isEmpty(dir)) {
                    if (dir.startsWith(":classpath:/")) {
                        assets0 = new BundledRead(staticsCfg, dir);
                    } else {
                        Path p = Paths.get(dir, new String[0]);
                        if (Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0])) {
                            assets0 = new DirectRead(staticsCfg, dir);
                        }
                    }
                } else {
                    logger.debug("No statics: dir is empty `" + dir + "`");
                }
            }
            catch (IllegalStateException ise) {
                logger.error("Cant setup static assets: " + ise.getMessage() + ", noop.");
                assets0 = new NoStatics();
            }
            this.assets = assets0;
            this.cors = new CORS(config);
            return;
        }
    }

    public void start() {
        new Thread(() -> {
            try (ServerSocket socket = new ServerSocket(this.port);){
                Socket child;
                do {
                    if ((child = socket.accept()) == null) continue;
                    new Handler(child, this, this.maxRequestBytes, this.readTimeout).start();
                } while (child != null);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                System.exit(-1);
            }
        }){

            @Override
            public synchronized void start() {
                this.setPriority(7);
                this.setName("FairHttpServer");
                super.start();
            }
        }.start();
        try {
            logger.info("Listen at:\thttp://" + Inet4Address.getLocalHost().getHostAddress() + ":" + this.port);
        }
        catch (Exception e) {
            logger.error("Cant get local host: " + e.getMessage(), (Throwable)e);
        }
    }

    void handleRequest(Request request, Consumer<Response> responseConsumer) {
        boolean hasMatchPath = false;
        Function<Throwable, Void> errorHandler = t -> {
            responseConsumer.accept(this.errorHandler.apply((Throwable)t));
            return null;
        };
        for (Endpoint e : this.endpoints) {
            if (e.match(request.method(), request.path())) {
                CompletableFuture.runAsync(() -> e.call(request).thenApply(rsp -> this.cors.wrap(request, (Response)rsp)).thenAccept(responseConsumer).exceptionally(errorHandler));
                return;
            }
            if (hasMatchPath || !e.pathMatch(request.path())) continue;
            hasMatchPath = true;
        }
        if (hasMatchPath && request.method().equals("OPTIONS")) {
            responseConsumer.accept(this.cors.wrap(request, Response.NoContent()));
            return;
        }
        if (request.method().equals("GET")) {
            CompletableFuture.runAsync(() -> responseConsumer.accept(this.assets.apply(request.uri()))).exceptionally((Function)errorHandler);
        } else {
            responseConsumer.accept(Response.NotFound());
        }
    }

    public synchronized void setupDynamicEndpoints(Collection<DynamicRoute> routes) {
        for (DynamicRoute pretend : routes) {
            try {
                Endpoint ep = new Endpoint(pretend.method, pretend.endpoint, pretend.callback);
                this.endpoints.add(ep);
                logger.info("Added endpoint: " + ep);
            }
            catch (Exception e) {
                logger.error("Cant add endpoint '" + pretend + "' :: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void setupConfigEndpoints(Collection<String> raw) {
        for (String pretend : raw) {
            try {
                Endpoint ep = new Endpoint(pretend);
                this.endpoints.add(ep);
                logger.info("Added endpoint: " + ep);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (Exception e) {
                logger.error("Cant add endpoint '" + pretend + "' :: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized boolean removeEndpoint(String method, String signature) {
        for (Endpoint e : this.endpoints) {
            if (!e.equals(method, signature)) continue;
            this.endpoints.remove(e);
            return true;
        }
        return false;
    }

    public synchronized boolean addEndpoint(String method, String endpoint, BiFunction<Request, Map<String, String>, CompletionStage<Response>> callback) {
        return this.endpoints.add(new Endpoint(method, endpoint, callback));
    }

    public void setupErrorHandler(Function<Throwable, Response> errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
    }
}

