/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.tools.websocket.Opcode;
import org.logdoc.fairhttp.service.tools.websocket.extension.DefaultExtension;
import org.logdoc.fairhttp.service.tools.websocket.extension.IExtension;
import org.logdoc.fairhttp.service.tools.websocket.frames.AFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.BinaryFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.CloseFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.Frame;
import org.logdoc.fairhttp.service.tools.websocket.frames.PingFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.PongFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.TextFrame;
import org.logdoc.helpers.Texts;

public final class WebSocket
extends Response {
    final Consumer<ErrorRef> readErrorConsumer;
    final Consumer<ErrorRef> writeErrorConsumer;
    private final IExtension extension;
    private final Consumer<String> textConsumer;
    private final Consumer<byte[]> binaryConsumer;
    private final Consumer<WebSocket> pingConsumer;
    private final Consumer<WebSocket> pongConsumer;
    private final Consumer<CloseReason> closeConsumer;
    private int frameStage;
    private int payloadlength;
    private AFrame frame;
    private Frame incompleteframe;
    private Opcode optcode;
    private boolean mask;
    private boolean closed;
    private Drive drive;
    private byte[] payload;
    private byte[] maskkey;
    private OutputStream os;
    private InetSocketAddress remote;

    WebSocket(IExtension extension, Consumer<String> textConsumer, Consumer<byte[]> binaryConsumer, Consumer<WebSocket> pingConsumer, Consumer<WebSocket> pongConsumer, Consumer<CloseReason> closeConsumer, Consumer<ErrorRef> readErrorConsumer, Consumer<ErrorRef> writeErrorConsumer) {
        super(101, "Websocket Connection Upgrade");
        this.extension = extension;
        this.textConsumer = textConsumer;
        this.binaryConsumer = binaryConsumer;
        this.pingConsumer = pingConsumer;
        this.pongConsumer = pongConsumer;
        this.closeConsumer = closeConsumer;
        this.readErrorConsumer = readErrorConsumer;
        this.writeErrorConsumer = writeErrorConsumer;
    }

    public InetSocketAddress remote() {
        return this.remote;
    }

    public String wsId() {
        return (String)this.headers.get("Sec-WebSocket-Accept");
    }

    private void nextByte(byte b) {
        if (this.closed || b == -1) {
            return;
        }
        switch (this.frameStage++) {
            case -1: {
                this.frameStage = -1;
                this.drive.accept(b);
                break;
            }
            case 0: {
                this.optcode = this.toOpcode((byte)(b & 0xF));
                if (this.optcode == null) {
                    this.readErrorConsumer.accept(this.error("Unknown opcode " + (short)(b & 0xF)));
                    return;
                }
                this.frame = AFrame.get(this.optcode);
                this.frame.setFin(b >> 8 != 0);
                this.frame.setRSV1((b & 0x40) != 0);
                this.frame.setRSV2((b & 0x20) != 0);
                this.frame.setRSV3((b & 0x10) != 0);
                break;
            }
            case 1: {
                this.mask = (b & 0xFFFFFF80) != 0;
                this.payloadlength = (byte)(b & 0x7F);
                if (this.payloadlength <= 125) break;
                if (this.optcode == Opcode.PING || this.optcode == Opcode.PONG || this.optcode == Opcode.CLOSING) {
                    this.readErrorConsumer.accept(this.error("more than 125 octets payload"));
                    return;
                }
                this.drive = this.payloadlength == 126 ? new Drive(2, bytes -> {
                    this.frameStage = 2;
                    byte[] sizebytes = new byte[3];
                    sizebytes[1] = bytes[0];
                    sizebytes[2] = bytes[1];
                    this.payloadlength = new BigInteger(sizebytes).intValue();
                }) : new Drive(8, bytes -> {
                    this.frameStage = 2;
                    this.payloadlength = (int)new BigInteger((byte[])bytes).longValue();
                });
                this.frameStage = -1;
                break;
            }
            case 2: {
                this.payload = new byte[this.payloadlength];
                this.frameStage = -1;
                if (this.mask) {
                    this.drive = new Drive(4, bytes -> {
                        this.maskkey = bytes;
                        this.drive = new Drive(this.payloadlength, bb -> {
                            this.frameStage = 3;
                            for (int i = 0; i < this.payloadlength; ++i) {
                                this.payload[i] = (byte)(bb[i] ^ this.maskkey[i % 4]);
                            }
                        });
                    });
                    break;
                }
                this.drive = new Drive(this.payloadlength, bytes -> {
                    this.frameStage = 3;
                    this.payload = bytes;
                });
                break;
            }
            case 3: {
                this.frameStage = 0;
                this.frame.setPayload(this.payload);
                IExtension ext = null;
                if (this.frame.getOpcode() != Opcode.CONTINUOUS && (this.frame.isRSV1() || this.frame.isRSV2() || this.frame.isRSV3())) {
                    ext = this.extension;
                }
                if (ext == null) {
                    ext = new DefaultExtension();
                }
                if (ext.isFrameValid(this.frame)) {
                    try {
                        ext.decodeFrame(this.frame);
                        if (this.frame.isValid()) {
                            this.process(this.frame);
                            break;
                        }
                        this.readErrorConsumer.accept(this.error("Invalid frame catched: " + this.frame));
                    }
                    catch (Exception e) {
                        this.readErrorConsumer.accept(this.error("Frame processing error: " + this.frame + " :: " + e.getMessage(), e));
                    }
                    break;
                }
                this.readErrorConsumer.accept(this.error("Extension cant decode frame: " + this.frame));
            }
        }
    }

    private void process(Frame frame) {
        Opcode curop = frame.getOpcode();
        if (curop == Opcode.CLOSING) {
            int code = 1005;
            String reason = "";
            if (frame instanceof CloseFrame) {
                code = ((CloseFrame)frame).getCloseCode();
                reason = ((CloseFrame)frame).getMessage();
            }
            this.close(code, reason, true);
        } else if (curop == Opcode.PING) {
            this.pingConsumer.accept(this);
        } else if (curop == Opcode.PONG) {
            this.pongConsumer.accept(this);
        } else if (!frame.isFin() || curop == Opcode.CONTINUOUS) {
            this.processFrameContinuousAndNonFin(frame, curop);
        } else if (this.incompleteframe != null) {
            this.readErrorConsumer.accept(this.error("Continuous frame sequence not completed."));
        } else {
            this.contentReady(frame);
        }
    }

    private void contentReady(Frame frame) {
        byte[] data = frame.getPayloadData();
        if (frame.getOpcode() == Opcode.TEXT) {
            this.textConsumer.accept(new String(data, StandardCharsets.UTF_8));
        } else if (frame.getOpcode() == Opcode.BINARY) {
            this.binaryConsumer.accept(data);
        }
    }

    private void processFrameContinuousAndNonFin(Frame frame, Opcode curop) {
        if (curop != Opcode.CONTINUOUS) {
            this.incompleteframe = frame;
        } else if (frame.isFin()) {
            if (this.incompleteframe == null) {
                this.readErrorConsumer.accept(this.error("Continuous frame sequence was not started."));
                return;
            }
            this.incompleteframe.append(frame);
            ((AFrame)this.incompleteframe).isValid();
            this.contentReady(this.incompleteframe);
            this.incompleteframe = null;
        } else if (this.incompleteframe == null) {
            this.readErrorConsumer.accept(this.error("Continuous frame sequence was not started."));
            return;
        }
        if (curop == Opcode.CONTINUOUS && this.incompleteframe != null) {
            this.incompleteframe.append(frame);
        }
    }

    private Opcode toOpcode(byte opcode) {
        switch (opcode) {
            case 0: {
                return Opcode.CONTINUOUS;
            }
            case 1: {
                return Opcode.TEXT;
            }
            case 2: {
                return Opcode.BINARY;
            }
            case 8: {
                return Opcode.CLOSING;
            }
            case 9: {
                return Opcode.PING;
            }
            case 10: {
                return Opcode.PONG;
            }
        }
        return null;
    }

    public void close() {
        this.close(1000, null, false);
    }

    public void close(int code, String reason) {
        this.close(code, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(int code, String reason, boolean remote) {
        if (this.closed) {
            return;
        }
        WebSocket webSocket = this;
        synchronized (webSocket) {
            this.closed = true;
        }
        if (!remote) {
            try {
                this.sendFrame(new CloseFrame(code, reason));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeConsumer.accept(new CloseReason(code, reason, remote));
    }

    public void ping() {
        this.sendFrame(new PingFrame());
    }

    public void pong() {
        this.sendFrame(new PongFrame());
    }

    public void send(String message) {
        if (message == null) {
            this.writeErrorConsumer.accept(this.error("Message is null"));
            return;
        }
        TextFrame frame = new TextFrame();
        frame.setMasked(true);
        frame.setPayload(message.getBytes(StandardCharsets.UTF_8));
        this.sendFrame(frame);
    }

    public void send(byte[] message) {
        if (message == null) {
            this.writeErrorConsumer.accept(this.error("Message is null"));
            return;
        }
        BinaryFrame frame = new BinaryFrame();
        frame.setMasked(true);
        frame.setPayload(message);
        this.sendFrame(frame);
    }

    private synchronized void sendFrame(AFrame framedata) {
        if (this.closed) {
            this.writeErrorConsumer.accept(this.error("Websocket is closed"));
            return;
        }
        if (framedata == null) {
            this.writeErrorConsumer.accept(this.error("Frame is null"));
            return;
        }
        if (!framedata.isValid()) {
            this.writeErrorConsumer.accept(this.error("Invalid frame"));
            return;
        }
        try {
            this.extension.encodeFrame(framedata);
            byte[] mes = framedata.getPayloadData();
            int sizebytes = this.getSizeBytes(mes);
            byte optcode = this.fromOpcode(framedata.getOpcode());
            if (optcode == -1) {
                this.writeErrorConsumer.accept(this.error("Don't know how to handle " + framedata.getOpcode()));
                return;
            }
            byte one = (byte)(framedata.isFin() ? -128 : 0);
            one = (byte)(one | optcode);
            if (framedata.isRSV1()) {
                one = (byte)(one | this.getRSVByte(1));
            }
            if (framedata.isRSV2()) {
                one = (byte)(one | this.getRSVByte(2));
            }
            if (framedata.isRSV3()) {
                one = (byte)(one | this.getRSVByte(3));
            }
            this.os.write(one);
            byte[] payloadlengthbytes = this.toByteArray(mes.length, sizebytes);
            if (sizebytes == 1) {
                this.os.write(payloadlengthbytes[0]);
            } else if (sizebytes == 2) {
                this.os.write(126);
                this.os.write(payloadlengthbytes);
            } else if (sizebytes == 8) {
                this.os.write(127);
                this.os.write(payloadlengthbytes);
            } else {
                this.writeErrorConsumer.accept(this.error("Size representation not supported/specified"));
                return;
            }
            this.os.write(mes);
            this.os.flush();
        }
        catch (Exception e) {
            this.writeErrorConsumer.accept(this.error(Texts.notNull((Object)e.getMessage()), e));
        }
    }

    private int getSizeBytes(byte[] mes) {
        if (mes.length <= 125) {
            return 1;
        }
        if (mes.length <= 65535) {
            return 2;
        }
        return 8;
    }

    private byte getRSVByte(int rsv) {
        switch (rsv) {
            case 1: {
                return 64;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    private byte[] toByteArray(long val, int bytecount) {
        byte[] buffer = new byte[bytecount];
        int highest = 8 * bytecount - 8;
        for (int i = 0; i < bytecount; ++i) {
            buffer[i] = (byte)(val >>> highest - 8 * i);
        }
        return buffer;
    }

    private byte fromOpcode(Opcode opcode) {
        switch (opcode) {
            case CONTINUOUS: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSING: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        return -1;
    }

    private ErrorRef error(String error) {
        return this.error(error, null);
    }

    private ErrorRef error(String error, Throwable cause) {
        return new ErrorRef(this, error, cause);
    }

    void spinOff(Socket socket) {
        try {
            socket.setSoTimeout(0);
            this.os = socket.getOutputStream();
            this.remote = (InetSocketAddress)socket.getRemoteSocketAddress();
            new Thread(() -> {
                try {
                    this.os.write(this.asBytes());
                    InputStream is = socket.getInputStream();
                    do {
                        this.nextByte((byte)is.read());
                    } while (!socket.isClosed());
                }
                catch (Exception e) {
                    this.readErrorConsumer.accept(this.error("Critical socket error", e));
                    this.close(-2, e.getMessage());
                }
            }){

                @Override
                public synchronized void start() {
                    this.setDaemon(true);
                    super.start();
                }
            }.start();
        }
        catch (IOException e) {
            this.readErrorConsumer.accept(this.error("Critical socket error", e));
            this.close(-2, e.getMessage());
        }
    }

    public static class ErrorRef {
        public final WebSocket ws;
        public final String error;
        public final Throwable cause;

        private ErrorRef(WebSocket ws, String error, Throwable cause) {
            this.ws = ws;
            this.error = error;
            this.cause = cause;
        }
    }

    public static class CloseReason {
        public final int code;
        public final String reason;
        public final boolean remotelyInited;

        private CloseReason(int code, String reason, boolean remotelyInited) {
            this.code = code;
            this.reason = reason;
            this.remotelyInited = remotelyInited;
        }

        public String toString() {
            return "CloseReason{code=" + this.code + ", reason='" + this.reason + "', remotelyInited=" + this.remotelyInited + "}";
        }
    }

    private static class Drive
    implements Consumer<Byte> {
        private final ByteArrayOutputStream buf;
        private final Consumer<byte[]> finisher;
        private final int size;

        Drive(int size, Consumer<byte[]> finisher) {
            this.buf = new ByteArrayOutputStream(size);
            this.size = size;
            this.finisher = finisher;
        }

        @Override
        public void accept(Byte b) {
            this.buf.write(b.byteValue());
            if (this.buf.size() == this.size) {
                this.finisher.accept(this.buf.toByteArray());
                this.buf.reset();
            }
        }
    }
}

