/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http.statics;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logdoc.fairhttp.service.api.helpers.MimeType;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.statics.StaticRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectRead
extends StaticRead {
    private static final Logger logger = LoggerFactory.getLogger(DirectRead.class);
    private final Path root;

    public DirectRead(Config staticsCfg, String root) {
        super(staticsCfg);
        try {
            this.root = Paths.get(root, new String[0]);
        }
        catch (ConfigException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        if (!Files.exists(this.root, new LinkOption[0])) {
            throw new IllegalStateException("root dir doesnt exists");
        }
        logger.info("Static content root dir: " + this.root);
    }

    public static Response fileResponse(Path p, String mimeType, long size) {
        Response response = Response.Ok();
        response.header("Content-Type", mimeType);
        response.header("Content-Length", size);
        response.setPromise(os -> {
            byte[] buf = new byte[655360];
            try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                int read;
                while ((read = is.read(buf)) != -1) {
                    os.write(buf, 0, read);
                }
                os.flush();
            }
            catch (Exception e) {
                logger.error(p + " :: " + e.getMessage(), (Throwable)e);
            }
        });
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response apply(String webpath) {
        Path p;
        if ((webpath = webpath.replaceAll("/{2,}", "/")).startsWith("/")) {
            webpath = webpath.substring(1);
        }
        if (!Files.exists(p = this.root.resolve(webpath = webpath.replace('/', File.separatorChar)), new LinkOption[0])) {
            return this.map404(webpath);
        }
        Response response = this.pickCached(webpath);
        try {
            if (response != null) {
                Response response2 = response;
                return response2;
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                if (this.gotIndex) {
                    for (String idx : this.indexFile) {
                        if (!Files.exists(p.resolve(idx), new LinkOption[0]) || Files.isDirectory(p.resolve(idx), new LinkOption[0])) continue;
                        Response response3 = this.apply(webpath + "/" + p.getFileName());
                        return response3;
                    }
                }
                if (this.autoDirList) {
                    response = Response.Ok();
                    try (Stream<Path> fs = Files.list(p);){
                        response.setPayload(this.dirList(p.getFileName().toString(), fs.map(f -> {
                            try {
                                StaticRead.FRes fr = new StaticRead.FRes();
                                fr.isFile = !Files.isDirectory(f, new LinkOption[0]);
                                fr.time = LocalDateTime.from(Files.getLastModifiedTime(f, new LinkOption[0]).toInstant().atZone(ZoneId.systemDefault()));
                                fr.name = f.getFileName().toString();
                                fr.size = fr.isFile ? Files.size(f) : 0L;
                                return fr;
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage(), (Throwable)e);
                                return null;
                            }
                        }).filter(Objects::nonNull).collect(Collectors.toList())), MimeType.TEXTHTML);
                    }
                } else {
                    response = Response.Forbidden();
                }
            } else {
                int dot = p.getFileName().toString().lastIndexOf(46);
                String mime = null;
                if (dot > 0) {
                    mime = this.getMime(p.getFileName().toString().substring(dot));
                }
                if (mime == null && (mime = this.refreshMime(webpath)) == null) {
                    int[] head = new int[16];
                    try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                        int b = 0;
                        for (int i = 0; i < head.length && b != -1; ++i) {
                            head[i] = b = is.read();
                        }
                    }
                    mime = MimeType.guessMime(head).toString();
                    this.rememberMime(webpath, mime);
                }
                long size = Files.size(p);
                response = Response.Ok();
                response.header("Content-Type", mime);
                response.header("Content-Length", size);
                response.setPromise(os -> {
                    byte[] buf = new byte[655360];
                    try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                        int read;
                        while ((read = is.read(buf)) != -1) {
                            os.write(buf, 0, read);
                        }
                        os.flush();
                    }
                    catch (Exception e) {
                        logger.error(p + " :: " + e.getMessage(), (Throwable)e);
                    }
                });
            }
            Response dot = response;
            return dot;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            Response response4 = Response.ServerError();
            return response4;
        }
        finally {
            this.cacheMe(webpath, response);
        }
    }
}

