/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.http.statics;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.logdoc.fairhttp.service.api.helpers.MimeType;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.tools.ConfigTools;
import org.logdoc.helpers.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StaticRead
implements Function<String, Response> {
    protected static final Logger logger = LoggerFactory.getLogger(StaticRead.class);
    private static final DateTimeFormatter format = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm");
    private static final String autoIdxPrm = "auto_index";
    private static final String indexesPrm = "index_files";
    private static final String map404To = "map404_to";
    private static final String cachePrm = "memory_cache";
    private static final String mimesPrm = "mime_types";
    private static final String cacheEnblPrm = "enabled";
    private static final String cacheSizePrm = "max_file_size";
    private static final String cacheLifePrm = "lifetime";
    private static final String mimeMimePrm = "mime";
    private static final String mimeExtPrm = "ext";
    protected final boolean autoDirList;
    protected final boolean gotIndex;
    protected final Set<String> indexFile;
    protected final boolean cache;
    protected final long maxCacheSize;
    protected final long maxCacheLife;
    protected final String map404Path;
    private final ConcurrentMap<String, String> mimes;
    private final ConcurrentMap<String, Response> cachedMap;
    private final ConcurrentMap<String, ScheduledFuture<?>> futuresMap;
    private final Executor cacheCleanTP;

    protected StaticRead(Config staticCfg) {
        try {
            this.indexFile = new HashSet<String>(3);
            this.mimes = new ConcurrentHashMap<String, String>(8);
            this.autoDirList = ConfigTools.sureBool(staticCfg, autoIdxPrm);
            logger.info("Static folders auto indexing is " + (this.autoDirList ? "en" : "dis") + "abled.");
            List<String> names = ConfigTools.sureStrings(staticCfg, indexesPrm);
            if (!Texts.isEmpty(names)) {
                this.indexFile.addAll(names);
            }
            boolean bl = this.gotIndex = !this.indexFile.isEmpty();
            if (this.gotIndex) {
                logger.info("Index files defined names: " + this.indexFile);
            } else {
                logger.info("No index files defined.");
            }
            this.map404Path = ConfigTools.sureNN(staticCfg, map404To) ? staticCfg.getString(map404To) : null;
            Config cacheCfg = ConfigTools.sureConf(staticCfg, cachePrm);
            long cs = 0L;
            long cl = 0L;
            if (cacheCfg != null) {
                this.cache = ConfigTools.sureBool(cacheCfg, cacheEnblPrm);
                if (this.cache) {
                    cs = 524288L;
                    cl = Duration.of(3L, ChronoUnit.MINUTES).toMillis();
                    if (ConfigTools.sureNN(cacheCfg, cacheLifePrm)) {
                        cl = cacheCfg.getDuration(cacheLifePrm, TimeUnit.MILLISECONDS);
                    }
                    if (ConfigTools.sureNN(cacheCfg, cacheSizePrm)) {
                        cs = cacheCfg.getBytes(cacheSizePrm);
                    }
                }
            } else {
                this.cache = false;
            }
            this.maxCacheSize = cs;
            this.maxCacheLife = cl;
            if (this.cache) {
                this.cacheCleanTP = Executors.newScheduledThreadPool(Math.min(6, Math.max(2, Runtime.getRuntime().availableProcessors() / 2)));
                this.cachedMap = new ConcurrentHashMap<String, Response>(64);
                this.futuresMap = new ConcurrentHashMap(64);
                logger.info("Static caching is enabled for files smaller or equal to " + this.maxCacheSize + " bytes for a period of " + Duration.of(this.maxCacheLife, ChronoUnit.MILLIS).toSeconds() + " seconds.");
            } else {
                this.cacheCleanTP = null;
                this.cachedMap = null;
                this.futuresMap = null;
                logger.info("Static caching is disabled");
            }
            if (ConfigTools.sureNN(staticCfg, mimesPrm)) {
                List mcfgs = staticCfg.getConfigList(mimesPrm);
                for (Config mc : mcfgs) {
                    try {
                        String mime = new MimeType(mc.getString(mimeMimePrm)).toString();
                        HashSet<String> exts = new HashSet<String>(ConfigTools.sureStrings(mc, mimeExtPrm));
                        if (Texts.isEmpty((Object)mime) || Texts.isEmpty(exts)) continue;
                        for (String ext : exts) {
                            this.mimes.put(ext.trim().toLowerCase(), mime);
                        }
                        logger.info("Additional MIME type '" + mime + "' associated with extensions: " + exts);
                    }
                    catch (Exception er) {
                        logger.error(er.getMessage(), (Throwable)er);
                    }
                }
            }
            if (Texts.isEmpty(this.mimes)) {
                logger.info("No additional MIME types defined.");
            }
        }
        catch (ConfigException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected Response map404(String path) {
        if (this.map404Path == null || path.equals(this.map404Path)) {
            logger.info("Not found `" + path + "`");
            return Response.NotFound();
        }
        return (Response)this.apply(this.map404Path);
    }

    protected byte[] dirList(String dirName, Collection<FRes> content) {
        StringBuilder html = new StringBuilder("<html><head><title>Index of " + dirName + "</title></head><body><h1>Index of " + dirName + "</h1><hr><pre><a href=\"../\">../</a>\n");
        content.stream().sorted().forEach(f -> {
            boolean i = !f.isFile;
            String n = f.name + (i ? "/" : "");
            String d = f.time.format(format);
            String l = i ? "-" : Long.toString(f.size);
            html.append("<a href='").append((dirName + "/" + n).replaceAll("/{2,}", "/")).append("'>").append(n).append("</a>").append(" ".repeat(Math.max(0, 51 - n.length()))).append(d).append(" ".repeat(Math.max(0, 20 - l.length()))).append(l).append("\n");
        });
        html.append("</pre><hr></body></html>");
        return html.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected void cacheMe(String id, Response response) {
        if (!this.cache || response == null || response.size() <= 0 || (long)response.size() > this.maxCacheSize) {
            return;
        }
        if (this.futuresMap.get(id) != null) {
            try {
                ((ScheduledFuture)this.futuresMap.remove(id)).cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cachedMap.put(id, response);
        this.futuresMap.put(id, ((ScheduledExecutorService)this.cacheCleanTP).schedule(() -> (Response)this.cachedMap.remove(id), this.maxCacheLife, TimeUnit.MILLISECONDS));
    }

    protected String getMime(String ext) {
        if (Texts.isEmpty((Object)ext)) {
            return null;
        }
        return (String)this.mimes.get(ext.trim().toLowerCase());
    }

    protected String refreshMime(String id) {
        return (String)this.mimes.get(id);
    }

    protected void rememberMime(String id, String mime) {
        this.mimes.put(id, mime);
    }

    protected Response pickCached(String id) {
        return (Response)this.cachedMap.get(id);
    }

    protected static class FRes
    implements Comparable<FRes> {
        boolean exists;
        String name;
        long size;
        boolean isFile;
        LocalDateTime time;

        protected FRes() {
        }

        @Override
        public int compareTo(FRes o) {
            int res = Boolean.compare(this.isFile, o.isFile);
            return res == 0 ? this.name.compareTo(o.name) : res;
        }
    }
}

