/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.tools;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.logdoc.fairhttp.service.api.helpers.MimeType;
import org.logdoc.fairhttp.service.tools.Pair;
import org.logdoc.helpers.Digits;
import org.logdoc.helpers.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBinStreaming {
    private static final Logger logger = LoggerFactory.getLogger(HttpBinStreaming.class);
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private static final byte[] headerSeparator = new byte[]{13, 10, 13, 10};
    private static final byte[] fieldSeparator = new byte[]{13, 10};
    private static final byte[] streamEnd = new byte[]{45, 45};
    private static final byte[] boundaryPrefix = new byte[]{13, 10, 45, 45};

    public static byte[] getBoundary(MimeType contentType) {
        String boundaryStr = contentType.getParameter("boundary");
        if (boundaryStr == null) {
            throw new NullPointerException();
        }
        return boundaryStr.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static List<Pair<Integer, Integer>> markParts(byte[] body, byte[] boundary0) {
        int i;
        ArrayList<Pair<Integer, Integer>> marks = new ArrayList<Pair<Integer, Integer>>(8);
        byte[] boundary = new byte[boundaryPrefix.length + boundary0.length];
        System.arraycopy(boundaryPrefix, 0, boundary, 0, boundaryPrefix.length);
        System.arraycopy(boundary0, 0, boundary, boundaryPrefix.length, boundary0.length);
        ArrayList<Integer> starts = new ArrayList<Integer>(8);
        int j = 2;
        int from = -1;
        for (i = 0; i < body.length - boundary.length - streamEnd.length; ++i) {
            if (body[i] != boundary[j++]) {
                j = 0;
                from = i;
                continue;
            }
            if (j != boundary.length) continue;
            starts.add(from + boundary.length + 1);
            j = 0;
        }
        for (i = 0; i < starts.size(); ++i) {
            if (i == starts.size() - 1) {
                marks.add(Pair.create((Integer)starts.get(i), body.length - streamEnd.length - boundary.length - 1));
                continue;
            }
            marks.add(Pair.create((Integer)starts.get(i), (Integer)starts.get(i + 1) - boundary.length - 1));
        }
        return marks;
    }

    public static Consumer<Byte> headersTicker(ByteArrayOutputStream tmp, Consumer<Integer> bodyLengthConsumer, Consumer<Boolean> chunkedFlagConsumer, Consumer<MimeType> contentTypeConsumer, BiConsumer<String, String> headerConsumer, BiConsumer<String, String> cookieConsumer, Consumer<Void> step, Consumer<Void> stepOut) {
        return b -> {
            if (b == 10) {
                String headerLine = tmp.toString(StandardCharsets.UTF_8).trim();
                tmp.reset();
                int idx = headerLine.indexOf(58);
                if (idx != -1) {
                    String name = headerLine.substring(0, idx).trim();
                    if (!name.isEmpty()) {
                        String value = Texts.notNull((Object)headerLine.substring(idx + 1));
                        if (name.equalsIgnoreCase("Content-Length")) {
                            bodyLengthConsumer.accept(Digits.getInt((Object)value));
                        } else if (name.equalsIgnoreCase("Transfer-Encoding")) {
                            chunkedFlagConsumer.accept("chunked".equalsIgnoreCase(value));
                        } else if (name.equalsIgnoreCase("Content-Type")) {
                            try {
                                contentTypeConsumer.accept(new MimeType(value));
                            }
                            catch (Exception e) {
                                logger.warn("Cant parse request content-type :: " + e.getMessage(), (Throwable)e);
                            }
                        } else if (name.equalsIgnoreCase("Cookie")) {
                            name = "Cookie";
                            if (!value.isEmpty()) {
                                Arrays.stream(value.split(";")).filter(s -> s.contains("=")).forEach(c -> {
                                    String[] parts = c.split(Pattern.quote("="), 2);
                                    if (parts.length != 2) {
                                        return;
                                    }
                                    cookieConsumer.accept(Texts.notNull((Object)parts[0]), HttpBinStreaming.stringQuotes(parts[1]));
                                });
                            }
                        }
                        headerConsumer.accept(name.toUpperCase(), value);
                    }
                } else if (headerLine.isEmpty()) {
                    tmp.reset();
                    stepOut.accept(null);
                    return;
                }
                step.accept(null);
            } else {
                tmp.write(b.byteValue());
            }
        };
    }

    public static String stringQuotes(String value) {
        if (value == null) {
            return null;
        }
        if (!(value = Texts.notNull((Object)value)).startsWith("\"")) {
            return value;
        }
        return value.substring(1, value.length() - 1);
    }
}

