/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.tools.websocket.frames;

import java.util.Arrays;
import org.logdoc.fairhttp.service.tools.websocket.Opcode;
import org.logdoc.fairhttp.service.tools.websocket.frames.BinaryFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.CloseFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.ContinuousFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.Frame;
import org.logdoc.fairhttp.service.tools.websocket.frames.PingFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.PongFrame;
import org.logdoc.fairhttp.service.tools.websocket.frames.TextFrame;

public abstract class AFrame
implements Frame {
    private final Opcode optcode;
    private boolean fin;
    private byte[] unmaskedpayload;
    private boolean masked;
    private boolean rsv1;
    private boolean rsv2;
    private boolean rsv3;

    public abstract boolean isValid();

    public AFrame(Opcode op) {
        this.optcode = op;
        this.fin = true;
        this.masked = false;
        this.rsv1 = false;
        this.rsv2 = false;
        this.rsv3 = false;
    }

    @Override
    public boolean isRSV1() {
        return this.rsv1;
    }

    @Override
    public boolean isRSV2() {
        return this.rsv2;
    }

    @Override
    public boolean isRSV3() {
        return this.rsv3;
    }

    @Override
    public boolean isFin() {
        return this.fin;
    }

    @Override
    public Opcode getOpcode() {
        return this.optcode;
    }

    @Override
    public boolean getTransfereMasked() {
        return this.masked;
    }

    @Override
    public byte[] getPayloadData() {
        return this.unmaskedpayload;
    }

    @Override
    public void append(Frame frame) {
        byte[] b = frame.getPayloadData();
        if (this.unmaskedpayload == null) {
            this.unmaskedpayload = b;
        } else {
            byte[] tmp = new byte[this.unmaskedpayload.length + b.length];
            System.arraycopy(this.unmaskedpayload, 0, tmp, 0, this.unmaskedpayload.length);
            System.arraycopy(b, 0, tmp, this.unmaskedpayload.length, b.length);
            this.unmaskedpayload = tmp;
        }
        this.fin = frame.isFin();
    }

    public String toString() {
        return "AFramedata{optcode=" + this.optcode + ", fin=" + this.fin + ", unmaskedpayload=" + (String)(this.unmaskedpayload == null ? "NIL" : this.unmaskedpayload.length + "b") + ", masked=" + this.masked + ", rsv1=" + this.rsv1 + ", rsv2=" + this.rsv2 + ", rsv3=" + this.rsv3 + "}";
    }

    public void setPayload(byte[] payload) {
        this.unmaskedpayload = payload;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public void setRSV1(boolean rsv1) {
        this.rsv1 = rsv1;
    }

    public void setRSV2(boolean rsv2) {
        this.rsv2 = rsv2;
    }

    public void setRSV3(boolean rsv3) {
        this.rsv3 = rsv3;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }

    public static AFrame get(Opcode opcode) {
        if (opcode == null) {
            throw new IllegalArgumentException("Supplied opcode cannot be null");
        }
        switch (opcode) {
            case PING: {
                return new PingFrame();
            }
            case PONG: {
                return new PongFrame();
            }
            case TEXT: {
                return new TextFrame();
            }
            case BINARY: {
                return new BinaryFrame();
            }
            case CLOSING: {
                return new CloseFrame();
            }
            case CONTINUOUS: {
                return new ContinuousFrame();
            }
        }
        throw new IllegalArgumentException("Supplied opcode is invalid");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AFrame that = (AFrame)o;
        if (this.fin != that.fin) {
            return false;
        }
        if (this.masked != that.masked) {
            return false;
        }
        if (this.rsv1 != that.rsv1) {
            return false;
        }
        if (this.rsv2 != that.rsv2) {
            return false;
        }
        if (this.rsv3 != that.rsv3) {
            return false;
        }
        if (this.optcode != that.optcode) {
            return false;
        }
        return Arrays.equals(this.unmaskedpayload, that.unmaskedpayload);
    }

    public int hashCode() {
        int result = this.fin ? 1 : 0;
        result = 31 * result + this.optcode.hashCode();
        result = 31 * result + (this.unmaskedpayload != null ? Arrays.hashCode(this.unmaskedpayload) : 0);
        result = 31 * result + (this.masked ? 1 : 0);
        result = 31 * result + (this.rsv1 ? 1 : 0);
        result = 31 * result + (this.rsv2 ? 1 : 0);
        result = 31 * result + (this.rsv3 ? 1 : 0);
        return result;
    }
}

