/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.modules;

import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import org.apache.ibatis.session.Configuration;
import org.logdoc.fairhttp.service.DI;
import org.logdoc.fairhttp.service.api.helpers.Preloaded;
import org.logdoc.fairhttp.service.tools.MapperProvider;
import org.logdoc.helpers.Texts;

public abstract class ABatisModule
implements Preloaded {
    @Override
    public final void configure(Config rootConfig) {
        if (!rootConfig.hasPath("db")) {
            return;
        }
        Config dbConfig = rootConfig.getConfig("db");
        if (dbConfig.hasPath("url")) {
            this.configNamed(null, dbConfig);
        } else {
            dbConfig.root().forEach((key, value) -> this.configNamed(key.equals("default") ? null : key, dbConfig.getConfig(key)));
        }
        this.init();
    }

    private void configNamed(String name, Config dbConfig) {
        Config config;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(dbConfig.getString("url"));
        hikariConfig.setDriverClassName(dbConfig.getString("driver"));
        hikariConfig.setUsername(dbConfig.getString("username"));
        hikariConfig.setPassword(dbConfig.getString("password"));
        Config config2 = config = dbConfig.hasPath("hikaricp") ? dbConfig.getConfig("hikaricp") : null;
        if (config != null) {
            if (config.hasPath("dataSourceCLassName")) {
                hikariConfig.setDataSourceClassName(config.getString("dataSourceClassName"));
            }
            Config dataSourceConfig = config.getConfig("dataSource");
            dataSourceConfig.root().keySet().forEach(key -> hikariConfig.addDataSourceProperty(key, dataSourceConfig.getAnyRef(key)));
            hikariConfig.setAutoCommit(config.getBoolean("autoCommit"));
            hikariConfig.setConnectionTimeout(config.getLong("connectionTimeout") * 1000L);
            hikariConfig.setIdleTimeout(config.getLong("idleTimeout") * 1000L);
            hikariConfig.setMaxLifetime(config.getLong("maxLifetime") * 1000L);
            if (config.hasPath("connectionTestQuery")) {
                hikariConfig.setConnectionTestQuery(config.getString("connectionTestQuery"));
            }
            if (config.hasPath("minimumIdle")) {
                hikariConfig.setMinimumIdle(config.getInt("minimumIdle"));
            }
            hikariConfig.setMaximumPoolSize(config.getInt("maximumPoolSize"));
            if (config.hasPath("poolName")) {
                hikariConfig.setPoolName(config.getString("poolName"));
            }
            hikariConfig.setInitializationFailTimeout(config.getLong("initializationFailTimeout"));
            hikariConfig.setIsolateInternalQueries(config.getBoolean("isolateInternalQueries"));
            hikariConfig.setAllowPoolSuspension(config.getBoolean("allowPoolSuspension"));
            hikariConfig.setReadOnly(config.getBoolean("readOnly"));
            hikariConfig.setRegisterMbeans(config.getBoolean("registerMbeans"));
            if (config.hasPath("connectionInitSql")) {
                hikariConfig.setConnectionInitSql(config.getString("connectionInitSql"));
            }
            if (config.hasPath("catalog")) {
                hikariConfig.setCatalog(config.getString("catalog"));
            }
            if (config.hasPath("transactionIsolation")) {
                hikariConfig.setTransactionIsolation(config.getString("transactionIsolation"));
            }
            hikariConfig.setValidationTimeout(config.getLong("validationTimeout") * 1000L);
            hikariConfig.setLeakDetectionThreshold(config.getLong("leakDetectionThreshold") * 1000L);
            hikariConfig.validate();
        }
        DI.hikariDataSource(name, hikariConfig);
    }

    public abstract void init();

    protected final void addTypeHandler(Class<?> clas) {
        this.addTypeHandler(null, clas);
    }

    protected final void addTypeHandler(String named, Class<?> clas) {
        if (Texts.notNull((Object)named).equals("default")) {
            this.addTypeHandler(null, clas);
            return;
        }
        DI.gain(named, Configuration.class).getTypeHandlerRegistry().register(clas);
    }

    protected final void addAlias(String alias, Class<?> cls) {
        this.addAlias(null, alias, cls);
    }

    protected final void addAlias(String alias, String cls) {
        this.addAlias(null, alias, cls);
    }

    protected final void addSimpleAlias(Class<?> cls) {
        this.addSimpleAlias(null, cls);
    }

    protected final void addAlias(String named, String alias, Class<?> cls) {
        if (Texts.notNull((Object)named).equals("default")) {
            this.addAlias(null, alias, cls);
            return;
        }
        DI.gain(named, Configuration.class).getTypeAliasRegistry().registerAlias(alias, cls);
    }

    protected final void addSimpleAlias(String named, Class<?> cls) {
        if (Texts.notNull((Object)named).equals("default")) {
            this.addSimpleAlias(null, cls);
            return;
        }
        DI.gain(named, Configuration.class).getTypeAliasRegistry().registerAlias(cls);
    }

    protected final void addAlias(String named, String alias, String cls) {
        if (Texts.notNull((Object)named).equals("default")) {
            this.addAlias(null, alias, cls);
            return;
        }
        DI.gain(named, Configuration.class).getTypeAliasRegistry().registerAlias(alias, cls);
    }

    protected final <A> void addMapper(Class<A> clas) {
        this.addMapper(null, clas);
    }

    protected final <A> void addMapper(String named, Class<A> clas) {
        if (Texts.notNull((Object)named).equals("default")) {
            this.addMapper(null, clas);
            return;
        }
        DI.gain(named, Configuration.class).addMapper(clas);
        DI.bindProvider(named, clas, new MapperProvider<A>(named, clas));
    }
}

