/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service;

import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.logdoc.fairhttp.service.api.helpers.EagerSingleton;
import org.logdoc.fairhttp.service.api.helpers.Preloaded;
import org.logdoc.fairhttp.service.api.helpers.Route;
import org.logdoc.fairhttp.service.api.helpers.Singleton;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Server;
import org.logdoc.helpers.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DI {
    private static final Logger logger = LoggerFactory.getLogger((String)"FairServer");
    private static final ConcurrentMap<String, DI> refMap = new ConcurrentHashMap<String, DI>(4);
    private static Config config;
    private final Set<Class<? extends EagerSingleton>> eagers;
    private final Map<Class<?>, Class<?>> bindMap = new HashMap(64);
    private final Map<Integer, Supplier<?>> knownConstructors = new HashMap();
    private final Map<Integer, Object> singleMap = new HashMap<Integer, Object>();

    private DI() {
        this.eagers = new HashSet<Class<? extends EagerSingleton>>(8);
    }

    public static void endpoints(Route ... routes) {
        if (routes == null || routes.length == 0) {
            return;
        }
        DI.gain(Server.class).addEndpoints(Arrays.stream(routes).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    static synchronized void init(Config config0) {
        config = config0;
        logger.info("Initializing");
        refMap.putIfAbsent("", new DI());
    }

    private static DI ref(String name) {
        DI di = (DI)refMap.get(Texts.notNull((Object)name));
        if (di == null && name != null && !name.isEmpty()) {
            di = (DI)refMap.get("");
        }
        return di;
    }

    private static void initRef(String name) {
        if (Texts.isEmpty((Object)name) || refMap.get(name) != null) {
            return;
        }
        refMap.put(name, new DI());
    }

    static void preload(Class<Preloaded> clas) {
        try {
            logger.info("Preloading '" + clas.getName() + "'");
            Preloaded p = clas.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            p.configure(config);
            logger.info("Successfully loaded '" + clas.getName() + "'");
        }
        catch (Exception e) {
            logger.error("Cant load '" + clas.getName() + "' :: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void initEagers() {
        refMap.values().forEach(DI::initEagers0);
    }

    public static void unbind(Class<?> type) {
        DI.unbind(null, type);
    }

    public static void unbind(String named, Class<?> type) {
        if (type == null) {
            return;
        }
        DI.ref(named).unbind0(type);
    }

    public static <A> void bindProvider(Class<A> type, Supplier<? extends A> provider) {
        DI.bindProvider(null, type, provider);
    }

    public static <A> void bindProvider(String named, Class<A> type, Supplier<? extends A> provider) {
        DI.initRef(named);
        DI.ref(named).bindProvider0(type, provider);
    }

    public static <A, B extends A> void bind(Class<A> type, Class<B> implementation) {
        DI.bind(null, type, implementation);
    }

    public static <A, B extends A> void bind(String named, Class<A> type, Class<B> implementation) {
        DI.initRef(named);
        DI.ref(named).bind0(type, implementation);
    }

    public static <A> A gain(Class<A> clas) {
        return DI.gain(null, clas);
    }

    public static <A> A gain(String named, Class<A> clas) {
        return DI.ref(named).gainInternal(clas, Collections.emptyList());
    }

    public static void hikariDataSource(String name, HikariConfig config) {
        try {
            Configuration cfg = new Configuration(new Environment.Builder(Texts.notNull((Object)name)).transactionFactory((TransactionFactory)new JdbcTransactionFactory()).dataSource((DataSource)new HikariDataSource(config)).build());
            SqlSessionFactory factory = new SqlSessionFactoryBuilder().build(cfg);
            DI.bindProvider(name, Configuration.class, () -> cfg);
            DI.bindProvider(name, SqlSessionManager.class, () -> SqlSessionManager.newInstance((SqlSessionFactory)factory));
            DI.bind(name, SqlSessionFactory.class, SqlSessionManager.class);
        }
        catch (Exception e) {
            logger.error("Hikari DataSource init failed :: " + e.getMessage(), (Throwable)e);
            DI.unhikari(name);
        }
    }

    public static void shutName(String name) {
        if (Texts.isEmpty((Object)name)) {
            return;
        }
        refMap.remove(name);
    }

    public static void unhikari(String name) {
        DI.initRef(name);
        DI.unbind(name, SqlSessionFactory.class);
        DI.unbind(name, SqlSessionManager.class);
        DI.unbind(name, Configuration.class);
    }

    private synchronized void unbind0(Class<?> type) {
        this.bindMap.remove(type);
        this.knownConstructors.remove(type.hashCode());
        this.singleMap.remove(type.hashCode());
    }

    private synchronized void initEagers0() {
        if (this.eagers.isEmpty()) {
            return;
        }
        List init = Collections.emptyList();
        this.eagers.forEach(c -> {
            try {
                this.gainInternal((Class)c, init);
            }
            catch (Exception e) {
                logger.warn("Cant eager init singleton '" + c.getName() + "' :: " + e.getMessage(), (Throwable)e);
            }
        });
        this.eagers.clear();
    }

    private synchronized <A> void bindProvider0(Class<A> type, Supplier<? extends A> provider) {
        if (type == null) {
            throw new NullPointerException("Type is null");
        }
        if (provider == null) {
            throw new NullPointerException("Provider is null");
        }
        this.knownConstructors.put(type.hashCode(), provider);
    }

    private synchronized <A, B extends A> void bind0(Class<A> type, Class<B> implementation) {
        if (type == null) {
            throw new NullPointerException("Type is null");
        }
        if (implementation == null) {
            throw new NullPointerException("Implementation is null");
        }
        if (EagerSingleton.class.isAssignableFrom(implementation)) {
            this.eagers.add(implementation);
        }
        if (!type.equals(implementation)) {
            this.bindMap.put(type, implementation);
        }
        logger.info("Bound type '" + type.getName() + "' to implementation '" + implementation.getName() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> A gainInternal(Class<A> clas, Collection<Class<?>> ancestors) {
        boolean missed;
        if (clas == null) {
            return null;
        }
        if (clas.equals(Config.class)) {
            return (A)config;
        }
        Class<?> c = this.bindMap.get(clas);
        if (c != null) {
            if (ancestors.contains(c)) {
                return null;
            }
            ArrayList ancestorz = new ArrayList(ancestors);
            ancestorz.add(clas);
            return (A)this.gainInternal(c, ancestorz);
        }
        boolean singleton = Singleton.class.isAssignableFrom(clas);
        int hash = clas.hashCode();
        Object value = null;
        if (singleton) {
            value = this.singleMap.get(hash);
        }
        boolean bl = missed = value == null;
        if (missed) {
            value = this.build(clas, hash, ancestors);
        }
        if (value == null) {
            return null;
        }
        if (singleton && missed) {
            Map<Integer, Object> map = this.singleMap;
            synchronized (map) {
                this.singleMap.put(hash, value);
            }
        }
        return (A)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> A build(Class<A> clas, int hash, Collection<Class<?>> ancestors) {
        Constructor<?>[] ctrs;
        Supplier<Object> constructor = this.knownConstructors.get(hash);
        if (constructor != null) {
            return (A)constructor.get();
        }
        for (Constructor<?> c : ctrs = clas.getDeclaredConstructors()) {
            if (c.isSynthetic() || c.getParameterCount() != 0 || !Modifier.isPublic(c.getModifiers())) continue;
            constructor = () -> {
                try {
                    return c.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    logger.error("!!! Cant build object of type '" + clas.getName() + "' :: " + e.getMessage(), (Throwable)e);
                    return null;
                }
            };
            break;
        }
        if (constructor == null) {
            ArrayList arrayList = new ArrayList(ancestors);
            arrayList.add(clas);
            block4: for (Constructor<?> c : ctrs) {
                if (c.isSynthetic() || !Modifier.isPublic(c.getModifiers())) continue;
                Class<?>[] args = c.getParameterTypes();
                ArrayList<Object> argz = new ArrayList<Object>(args.length);
                for (Class<?> arg : args) {
                    if (arg == null || arg.isPrimitive() || arg.isArray() || ancestors.contains(arg) || Map.class.isAssignableFrom(arg) || Collection.class.isAssignableFrom(arg) || arg.equals(clas) || Request.class.isAssignableFrom(arg)) continue block4;
                    if (arg.equals(Config.class)) {
                        argz.add(config);
                        continue;
                    }
                    Object o = this.gainInternal(arg, arrayList);
                    if (o == null) continue block4;
                    argz.add(o);
                }
                if (argz.size() != c.getParameterCount()) {
                    logger.warn("Cant build constructors args: " + clas.getName() + " :: " + c);
                    continue;
                }
                ArrayList<Object> finalArgz = argz;
                constructor = () -> {
                    try {
                        return c.newInstance(finalArgz.toArray());
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        logger.error("!!! Cant build object of type '" + clas.getName() + "' :: " + e.getMessage(), (Throwable)e);
                        return null;
                    }
                };
                break;
            }
        }
        if (constructor == null) {
            logger.error("!!! Cant build object of type '" + clas.getName() + "' :: no valid constructor found.");
            return null;
        }
        Map<Integer, Supplier<?>> map = this.knownConstructors;
        synchronized (map) {
            this.knownConstructors.put(hash, constructor);
        }
        return (A)constructor.get();
    }
}

