/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.fairhttp.service.http.statics.DirectRead;
import org.logdoc.helpers.std.MimeType;
import org.logdoc.helpers.std.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);

    public static Response ok() {
        return Response.Ok();
    }

    public static Response ok(JsonNode json) {
        Response response = Response.Ok();
        response.setPayload(json.toString().getBytes(StandardCharsets.UTF_8), MimeTypes.JSON);
        return response;
    }

    public static Response ok(Path p) {
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                logger.error("Path not found: " + p);
                return Response.NotFound();
            }
            int[] head = new int[16];
            try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                int b = 0;
                for (int i = 0; i < head.length && b != -1; ++i) {
                    head[i] = b = is.read();
                }
            }
            return DirectRead.fileResponse(p, MimeType.guessMime((int[])head).toString(), Files.size(p));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Response.ServerError();
        }
    }

    public static Response ok(String data) {
        Response response = Response.Ok();
        response.setPayload(data.getBytes(StandardCharsets.UTF_8), MimeTypes.TEXTHTML);
        return response;
    }

    public static Response okText(String data) {
        Response response = Response.Ok();
        response.setPayload(data.getBytes(StandardCharsets.UTF_8), MimeTypes.TEXTPLAIN);
        return response;
    }

    public static Response ok(byte[] bytes) {
        Response response = Response.Ok();
        response.setPayload(bytes, MimeTypes.BINARY);
        return response;
    }

    public static Response status(int code, String message) {
        return new Response(code, message);
    }
}

