/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.helpers.Texts;

public class Route {
    public final String method;
    public final String endpoint;
    public final boolean indirect;
    public BiFunction<Request, Map<String, String>, ?> callback;

    private Route(String method, String endpoint, BiFunction<Request, Map<String, String>, ?> callback, boolean indirect) {
        this.method = method;
        this.endpoint = endpoint;
        this.callback = callback;
        this.indirect = indirect;
    }

    public static Route async(String method, String endpoint, BiFunction<Request, Map<String, String>, CompletionStage<Response>> callback) {
        if (Texts.isEmpty((Object)method)) {
            throw new NullPointerException("Method is not defined");
        }
        if (callback == null) {
            throw new NullPointerException("Callback is not defined");
        }
        return new Route(Texts.notNull((Object)method).toUpperCase(), Texts.isEmpty((Object)endpoint) ? "/" : Texts.notNull((Object)endpoint), callback, true);
    }

    public static Route sync(String method, String endpoint, BiFunction<Request, Map<String, String>, Response> callback) {
        if (Texts.isEmpty((Object)method)) {
            throw new NullPointerException("Method is not defined");
        }
        if (callback == null) {
            throw new NullPointerException("Callback is not defined");
        }
        return new Route(Texts.notNull((Object)method).toUpperCase(), Texts.isEmpty((Object)endpoint) ? "/" : Texts.notNull((Object)endpoint), callback, false);
    }

    public static Route async(Method method, String endpoint, BiFunction<Request, Map<String, String>, CompletionStage<Response>> callback) {
        if (Texts.isEmpty((Object)((Object)method))) {
            throw new NullPointerException("Method is not defined");
        }
        return Route.async(method.name(), endpoint, callback);
    }

    public static Route sync(Method method, String endpoint, BiFunction<Request, Map<String, String>, Response> callback) {
        if (Texts.isEmpty((Object)((Object)method))) {
            throw new NullPointerException("Method is not defined");
        }
        return Route.sync(method.name(), endpoint, callback);
    }

    public Route breakIf(BiFunction<Request, Map<String, String>, Boolean> breakIfPredicate, Response breakWithResponse) {
        if (breakIfPredicate == null || breakWithResponse == null) {
            return this;
        }
        BiFunction<Request, Map<String, String>, ?> orig = this.callback;
        this.callback = this.indirect ? (request, pathMap) -> (Boolean)breakIfPredicate.apply((Request)request, (Map<String, String>)pathMap) != false ? CompletableFuture.completedFuture(breakWithResponse) : orig.apply((Request)request, (Map<String, String>)pathMap) : (request, pathMap) -> (Boolean)breakIfPredicate.apply((Request)request, (Map<String, String>)pathMap) != false ? breakWithResponse : orig.apply((Request)request, (Map<String, String>)pathMap);
        return this;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        PATCH,
        OPTIONS,
        DELETE,
        HEAD,
        TRACE;

    }
}

