/*
 * Decompiled with CFR 0.152.
 */
package org.logdoc.fairhttp.service.api.helpers.endpoint;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.logdoc.fairhttp.service.api.helpers.endpoint.Signature;
import org.logdoc.fairhttp.service.http.Request;
import org.logdoc.fairhttp.service.http.Response;
import org.logdoc.helpers.gears.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endpoint
implements Comparable<Endpoint> {
    private static final Logger preLogger = LoggerFactory.getLogger((String)"PreFilters");
    private final String method;
    private final Signature signature;
    private final BiFunction<Request, Map<String, String>, Response> invoker;

    public Endpoint(String method, Signature signature, BiFunction<Request, Map<String, String>, Response> invoker) {
        this.method = method;
        this.signature = signature;
        this.invoker = invoker;
    }

    public Pair<Boolean, Boolean> match(String method, String hardPath) {
        return Pair.create((Object)this.method.equals(method), (Object)this.signature.matches(hardPath));
    }

    public Response call(Request request) {
        return this.invoker.apply(request, this.signature.values(request.path()));
    }

    @Override
    public int compareTo(Endpoint o) {
        int res = this.method.compareTo(o.method);
        return res == 0 ? this.signature.compareTo(o.signature) : res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.method.equals(((Endpoint)o).method) && this.signature.equals(endpoint.signature);
    }

    public boolean equals(String method, String signature) {
        return this.method.equals(method) && this.signature.equalString(signature);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.signature);
    }

    public String toString() {
        return this.method + "\t" + this.signature;
    }

    public boolean pathMatch(String hardPath) {
        return this.signature.matches(hardPath);
    }

    public String method() {
        return this.method;
    }

    public String signature() {
        return this.signature.proper;
    }
}

